/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;

@Evolving
public interface TableCatalog {
    public NameIdentifier[] listTables(Namespace var1) throws NoSuchSchemaException;

    public Table loadTable(NameIdentifier var1) throws NoSuchTableException;

    default public boolean tableExists(NameIdentifier ident) {
        try {
            return this.loadTable(ident) != null;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, Transforms.EMPTY_TRANSFORM, Distributions.NONE, new SortOrder[0]);
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, partitions, Distributions.NONE, new SortOrder[0]);
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Distribution distribution, SortOrder[] sortOrders) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, new Transform[0], distribution, sortOrders);
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Distribution distribution) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, new Transform[0], distribution, new SortOrder[0]);
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, SortOrder[] sortOrders) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, new Transform[0], Distributions.NONE, sortOrders);
    }

    default public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, Indexes.EMPTY_INDEXES);
    }

    public Table createTable(NameIdentifier var1, Column[] var2, String var3, Map<String, String> var4, Transform[] var5, Distribution var6, SortOrder[] var7, Index[] var8) throws NoSuchSchemaException, TableAlreadyExistsException;

    public Table alterTable(NameIdentifier var1, TableChange ... var2) throws NoSuchTableException, IllegalArgumentException;

    public boolean dropTable(NameIdentifier var1);

    default public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("purgeTable not supported.");
    }
}

