/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;

public final class DataTypeCasts {
    private static final Map<DataTypeRoot, Set<DataTypeRoot>> implicitCastingRules = new HashMap<DataTypeRoot, Set<DataTypeRoot>>();
    private static final Map<DataTypeRoot, Set<DataTypeRoot>> explicitCastingRules = new HashMap<DataTypeRoot, Set<DataTypeRoot>>();
    private static final Map<DataTypeRoot, Set<DataTypeRoot>> compatibleCastingRules = new HashMap<DataTypeRoot, Set<DataTypeRoot>>();

    public static boolean supportsCast(DataType sourceType, DataType targetType, boolean allowExplicit) {
        return DataTypeCasts.supportsCasting(sourceType, targetType, allowExplicit);
    }

    public static boolean supportsCompatibleCast(DataType sourceType, DataType targetType) {
        if (sourceType.copy(true).equals(targetType.copy(true))) {
            return true;
        }
        return compatibleCastingRules.get((Object)targetType.getTypeRoot()).contains((Object)sourceType.getTypeRoot());
    }

    private static boolean supportsCasting(DataType sourceType, DataType targetType, boolean allowExplicit) {
        if (sourceType.isNullable() && !targetType.isNullable() && !allowExplicit) {
            return false;
        }
        if (sourceType.copy(true).equals(targetType.copy(true))) {
            return true;
        }
        DataTypeRoot sourceRoot = sourceType.getTypeRoot();
        DataTypeRoot targetRoot = targetType.getTypeRoot();
        if (implicitCastingRules.get((Object)targetRoot).contains((Object)sourceRoot)) {
            return true;
        }
        if (allowExplicit) {
            return explicitCastingRules.get((Object)targetRoot).contains((Object)sourceRoot);
        }
        return false;
    }

    private static CastingRuleBuilder castTo(DataTypeRoot targetType) {
        return new CastingRuleBuilder(targetType);
    }

    private static DataTypeRoot[] allTypes() {
        return DataTypeRoot.values();
    }

    private DataTypeCasts() {
    }

    static {
        for (DataTypeRoot typeRoot : DataTypeCasts.allTypes()) {
            DataTypeCasts.castTo(typeRoot).implicitFrom(typeRoot).build();
        }
        DataTypeCasts.castTo(DataTypeRoot.CHAR).implicitFrom(DataTypeRoot.CHAR).explicitFromFamily(DataTypeFamily.PREDEFINED, DataTypeFamily.CONSTRUCTED).compatibleFrom(DataTypeRoot.CHAR, DataTypeRoot.VARCHAR).build();
        DataTypeCasts.castTo(DataTypeRoot.VARCHAR).implicitFromFamily(DataTypeFamily.CHARACTER_STRING).explicitFromFamily(DataTypeFamily.PREDEFINED, DataTypeFamily.CONSTRUCTED).compatibleFrom(DataTypeRoot.CHAR, DataTypeRoot.VARCHAR).build();
        DataTypeCasts.castTo(DataTypeRoot.BOOLEAN).implicitFrom(DataTypeRoot.BOOLEAN).explicitFromFamily(DataTypeFamily.CHARACTER_STRING, DataTypeFamily.INTEGER_NUMERIC).compatibleFrom(DataTypeRoot.BOOLEAN).build();
        DataTypeCasts.castTo(DataTypeRoot.BINARY).implicitFrom(DataTypeRoot.BINARY).explicitFromFamily(DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.VARBINARY).compatibleFrom(DataTypeRoot.BINARY, DataTypeRoot.VARBINARY).build();
        DataTypeCasts.castTo(DataTypeRoot.VARBINARY).implicitFromFamily(DataTypeFamily.BINARY_STRING).explicitFromFamily(DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BINARY).compatibleFrom(DataTypeRoot.BINARY, DataTypeRoot.VARBINARY).build();
        DataTypeCasts.castTo(DataTypeRoot.DECIMAL).implicitFromFamily(DataTypeFamily.NUMERIC).explicitFromFamily(DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build();
        DataTypeCasts.castTo(DataTypeRoot.TINYINT).implicitFrom(DataTypeRoot.TINYINT).explicitFromFamily(DataTypeFamily.NUMERIC, DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.TINYINT).build();
        DataTypeCasts.castTo(DataTypeRoot.SMALLINT).implicitFrom(DataTypeRoot.TINYINT, DataTypeRoot.SMALLINT).explicitFromFamily(DataTypeFamily.NUMERIC, DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.SMALLINT).build();
        DataTypeCasts.castTo(DataTypeRoot.INTEGER).implicitFrom(DataTypeRoot.TINYINT, DataTypeRoot.SMALLINT, DataTypeRoot.INTEGER).explicitFromFamily(DataTypeFamily.NUMERIC, DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.INTEGER, DataTypeRoot.DATE, DataTypeRoot.TIME_WITHOUT_TIME_ZONE).build();
        DataTypeCasts.castTo(DataTypeRoot.BIGINT).implicitFrom(DataTypeRoot.TINYINT, DataTypeRoot.SMALLINT, DataTypeRoot.INTEGER, DataTypeRoot.BIGINT).explicitFromFamily(DataTypeFamily.NUMERIC, DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.BIGINT).build();
        DataTypeCasts.castTo(DataTypeRoot.FLOAT).implicitFrom(DataTypeRoot.TINYINT, DataTypeRoot.SMALLINT, DataTypeRoot.INTEGER, DataTypeRoot.BIGINT, DataTypeRoot.FLOAT, DataTypeRoot.DECIMAL).explicitFromFamily(DataTypeFamily.NUMERIC, DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.FLOAT).build();
        DataTypeCasts.castTo(DataTypeRoot.DOUBLE).implicitFromFamily(DataTypeFamily.NUMERIC).explicitFromFamily(DataTypeFamily.CHARACTER_STRING).explicitFrom(DataTypeRoot.BOOLEAN, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).compatibleFrom(DataTypeRoot.DOUBLE).build();
        DataTypeCasts.castTo(DataTypeRoot.DATE).implicitFrom(DataTypeRoot.DATE, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(DataTypeFamily.TIMESTAMP, DataTypeFamily.CHARACTER_STRING).compatibleFrom(DataTypeRoot.INTEGER, DataTypeRoot.DATE, DataTypeRoot.TIME_WITHOUT_TIME_ZONE).build();
        DataTypeCasts.castTo(DataTypeRoot.TIME_WITHOUT_TIME_ZONE).implicitFrom(DataTypeRoot.TIME_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(DataTypeFamily.TIME, DataTypeFamily.TIMESTAMP, DataTypeFamily.CHARACTER_STRING).compatibleFrom(DataTypeRoot.INTEGER, DataTypeRoot.DATE, DataTypeRoot.TIME_WITHOUT_TIME_ZONE).build();
        DataTypeCasts.castTo(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).implicitFrom(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).explicitFromFamily(DataTypeFamily.DATETIME, DataTypeFamily.CHARACTER_STRING, DataTypeFamily.NUMERIC).compatibleFrom(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).build();
        DataTypeCasts.castTo(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).implicitFrom(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(DataTypeFamily.DATETIME, DataTypeFamily.CHARACTER_STRING, DataTypeFamily.NUMERIC).compatibleFrom(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build();
    }

    private static class CastingRuleBuilder {
        private final DataTypeRoot targetType;
        private final Set<DataTypeRoot> implicitSourceTypes = new HashSet<DataTypeRoot>();
        private final Set<DataTypeRoot> explicitSourceTypes = new HashSet<DataTypeRoot>();
        private final Set<DataTypeRoot> compatibleSourceTypes = new HashSet<DataTypeRoot>();

        CastingRuleBuilder(DataTypeRoot targetType) {
            this.targetType = targetType;
        }

        CastingRuleBuilder implicitFrom(DataTypeRoot ... sourceTypes) {
            this.implicitSourceTypes.addAll(Arrays.asList(sourceTypes));
            return this;
        }

        CastingRuleBuilder implicitFromFamily(DataTypeFamily ... sourceFamilies) {
            for (DataTypeFamily family : sourceFamilies) {
                for (DataTypeRoot root : DataTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.implicitSourceTypes.add(root);
                }
            }
            return this;
        }

        CastingRuleBuilder explicitFrom(DataTypeRoot ... sourceTypes) {
            this.explicitSourceTypes.addAll(Arrays.asList(sourceTypes));
            return this;
        }

        CastingRuleBuilder explicitFromFamily(DataTypeFamily ... sourceFamilies) {
            for (DataTypeFamily family : sourceFamilies) {
                for (DataTypeRoot root : DataTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.explicitSourceTypes.add(root);
                }
            }
            return this;
        }

        CastingRuleBuilder compatibleFrom(DataTypeRoot ... sourceTypes) {
            this.compatibleSourceTypes.addAll(Arrays.asList(sourceTypes));
            return this;
        }

        CastingRuleBuilder explicitNotFromFamily(DataTypeFamily ... sourceFamilies) {
            for (DataTypeFamily family : sourceFamilies) {
                for (DataTypeRoot root : DataTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.explicitSourceTypes.remove((Object)root);
                }
            }
            return this;
        }

        void build() {
            implicitCastingRules.put(this.targetType, this.implicitSourceTypes);
            explicitCastingRules.put(this.targetType, this.explicitSourceTypes);
            compatibleCastingRules.put(this.targetType, this.compatibleSourceTypes);
        }
    }
}

