/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiSchema;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiTable;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.HudiHMSSchema;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.HudiHMSTable;
import org.apache.gravitino.catalog.lakehouse.hudi.ops.HudiCatalogBackendOps;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.hive.CachedClientPool;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.thrift.TException;

public class HudiHMSBackendOps
implements HudiCatalogBackendOps {
    private static final Map<String, String> CONFIG_CONVERTER = ImmutableMap.of((Object)"uri", (Object)HiveConf.ConfVars.METASTOREURIS.varname);
    private static final String HUDI_PACKAGE_PREFIX = "org.apache.hudi";
    @VisibleForTesting
    CachedClientPool clientPool;

    @Override
    public void initialize(Map<String, String> properties) {
        this.clientPool = new CachedClientPool((Configuration)this.buildHiveConf(properties), properties);
    }

    @Override
    public HudiSchema loadSchema(NameIdentifier schemaIdent) throws NoSuchSchemaException {
        try {
            Database database = (Database)this.clientPool.run(client -> client.getDatabase(schemaIdent.name()));
            return HudiHMSSchema.builder().withBackendSchema(database).build();
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchSchemaException(e, "Hudi schema (database) does not exist: %s in Hive Metastore", new Object[]{schemaIdent.name()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to load Hudi schema (database) " + schemaIdent.name() + " from Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            return (NameIdentifier[])this.clientPool.run(c -> (NameIdentifier[])c.getAllDatabases().stream().map(db -> NameIdentifier.of((Namespace)namespace, (String)db)).toArray(NameIdentifier[]::new));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all schemas (database) under namespace : " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HudiHMSSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public HudiHMSSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        if (!this.schemaExists(schemaIdent)) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s", new Object[]{namespace});
        }
        try {
            return (NameIdentifier[])this.clientPool.run(c -> {
                List allTables = c.getAllTables(schemaIdent.name());
                return (NameIdentifier[])c.getTableObjectsByName(schemaIdent.name(), allTables).stream().filter(this::checkHudiTable).map(t -> NameIdentifier.of((Namespace)namespace, (String)t.getTableName())).toArray(NameIdentifier[]::new);
            });
        }
        catch (UnknownDBException e) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s in Hive Metastore", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under the namespace : " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HudiTable loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            Table table = (Table)this.clientPool.run(client -> client.getTable(schemaIdent.name(), tableIdent.name()));
            if (!this.checkHudiTable(table)) {
                throw new NoSuchTableException("Table %s is not a Hudi table in Hive Metastore", new Object[]{tableIdent.name()});
            }
            return HudiHMSTable.builder().withBackendTable(table).build();
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException((Throwable)e, "Hudi table does not exist: %s in Hive Metastore", new Object[]{tableIdent.name()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to load Hudi table " + tableIdent.name() + " from Hive metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HudiHMSTable createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public HudiHMSTable alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean dropTable(NameIdentifier ident) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        if (this.clientPool != null) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    private boolean checkHudiTable(Table table) {
        return table.getSd().getInputFormat() != null && table.getSd().getInputFormat().startsWith(HUDI_PACKAGE_PREFIX);
    }

    private HiveConf buildHiveConf(Map<String, String> properties) {
        Configuration hadoopConf = new Configuration();
        HashMap byPassConfigs = Maps.newHashMap();
        HashMap convertedConfigs = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (key.startsWith("gravitino.bypass.")) {
                byPassConfigs.put(key.substring("gravitino.bypass.".length()), value);
            } else if (CONFIG_CONVERTER.containsKey(key)) {
                convertedConfigs.put(CONFIG_CONVERTER.get(key), value);
            }
        });
        byPassConfigs.forEach((arg_0, arg_1) -> ((Configuration)hadoopConf).set(arg_0, arg_1));
        convertedConfigs.forEach((arg_0, arg_1) -> ((Configuration)hadoopConf).set(arg_0, arg_1));
        return new HiveConf(hadoopConf, HudiHMSBackendOps.class);
    }
}

