/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;

public class LocalStatisticsImpl
extends StatisticsImpl {
    private final long[] longStorage;
    private final double[] doubleStorage;
    private final int longCount;
    private final transient Object[] longLocks;
    private final transient Object[] doubleLocks;

    public LocalStatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, boolean atomicIncrements, int osStatFlags, StatisticsManager statisticsManager) {
        super(type, textId, numericId, uniqueId, osStatFlags, statisticsManager);
        int i;
        StatisticsTypeImpl realType = (StatisticsTypeImpl)type;
        this.longCount = realType.getLongStatCount();
        int doubleCount = realType.getDoubleStatCount();
        if (this.longCount > 0) {
            this.longStorage = new long[this.longCount];
            if (atomicIncrements) {
                this.longLocks = new Object[this.longCount];
                for (i = 0; i < this.longLocks.length; ++i) {
                    this.longLocks[i] = new Object();
                }
            } else {
                this.longLocks = null;
            }
        } else {
            this.longStorage = null;
            this.longLocks = null;
        }
        if (doubleCount > 0) {
            this.doubleStorage = new double[doubleCount];
            if (atomicIncrements) {
                this.doubleLocks = new Object[doubleCount];
                for (i = 0; i < this.doubleLocks.length; ++i) {
                    this.doubleLocks[i] = new Object();
                }
            } else {
                this.doubleLocks = null;
            }
        } else {
            this.doubleStorage = null;
            this.doubleLocks = null;
        }
    }

    public static Statistics createNonAtomic(StatisticsType type, String textId, long numericId, long uniqueId, int osStatFlags, StatisticsManager statisticsManager) {
        return new LocalStatisticsImpl(type, textId, numericId, uniqueId, false, osStatFlags, statisticsManager);
    }

    @Override
    public boolean isAtomic() {
        return this.longLocks != null || this.doubleLocks != null;
    }

    private int getOffsetFromLongId(int id) {
        return id;
    }

    private int getOffsetFromDoubleId(int id) {
        return id - this.longCount;
    }

    @Override
    protected void _setLong(int id, long value) {
        int offset = this.getOffsetFromLongId(id);
        this.longStorage[offset] = value;
    }

    @Override
    protected void _setDouble(int id, double value) {
        int offset = this.getOffsetFromDoubleId(id);
        this.doubleStorage[offset] = value;
    }

    @Override
    protected long _getLong(int id) {
        int offset = this.getOffsetFromLongId(id);
        return this.longStorage[offset];
    }

    @Override
    protected double _getDouble(int id) {
        int offset = this.getOffsetFromDoubleId(id);
        return this.doubleStorage[offset];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _incLong(int id, long delta) {
        int offset = this.getOffsetFromLongId(id);
        if (this.longLocks != null) {
            Object object = this.longLocks[offset];
            synchronized (object) {
                int n = offset;
                this.longStorage[n] = this.longStorage[n] + delta;
            }
        } else {
            int n = offset;
            this.longStorage[n] = this.longStorage[n] + delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _incDouble(int id, double delta) {
        int offset = this.getOffsetFromDoubleId(id);
        if (this.doubleLocks != null) {
            Object object = this.doubleLocks[offset];
            synchronized (object) {
                int n = offset;
                this.doubleStorage[n] = this.doubleStorage[n] + delta;
            }
        } else {
            int n = offset;
            this.doubleStorage[n] = this.doubleStorage[n] + delta;
        }
    }
}

