/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.datasource.AbstractPoolCache;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TranxPoolCacheImpl
extends AbstractPoolCache {
    private static final long serialVersionUID = 3295652525163658888L;
    private static final Logger logger = LogService.getLogger();
    private XADataSource m_xads;

    public TranxPoolCacheImpl(XADataSource xads, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super(eventListner, configs);
        this.m_xads = xads;
        this.initializePool();
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((PooledConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((PooledConnection)connectionObject).close();
                connectionObject = null;
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("AbstractPoolcache::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        if (this.m_xads != null) {
            XAConnection poolConn = null;
            try {
                poolConn = this.m_xads.getXAConnection(this.configProps.getUser(), this.configProps.getPassword());
            }
            catch (SQLException sqx) {
                throw new PoolException("TranxPoolCacheImpl::getNewConnection: Exception in creating new transaction PooledConnection", sqx);
            }
            poolConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
            return poolConn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TranxPoolCacheImpl::getNewConnection: ConnectionPoolCache not intialized with XADatasource");
        }
        throw new PoolException("TranxPoolCacheImpl::getNewConnection: ConnectionPoolCache not intialized with XADatasource");
    }

    @VisibleForTesting
    void setXADataSource(XADataSource xads) {
        this.m_xads = xads;
    }
}

