/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.AbstractGroupOrRangeJunction;
import org.apache.geode.cache.query.internal.AllGroupJunction;
import org.apache.geode.cache.query.internal.CompiledLike;
import org.apache.geode.cache.query.internal.CompiledNegation;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CompositeGroupJunction;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.GroupJunction;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.Indexable;
import org.apache.geode.cache.query.internal.Negatable;
import org.apache.geode.cache.query.internal.OrganizedOperands;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RangeJunction;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.Assert;

public class CompiledJunction
extends AbstractCompiledValue
implements Negatable {
    private final CompiledValue[] _operands;
    private int _operator = 0;
    private List unevaluatedFilterOperands = null;
    private static final String PLACEHOLDER_FOR_JOIN = "join";

    CompiledJunction(CompiledValue[] operands, int operator) {
        if (operator != 89 && operator != 91 || operands.length < 2) {
            throw new InternalGemFireError("operator=" + operator + "operands.length =" + operands.length);
        }
        this._operator = operator;
        this._operands = operands;
    }

    @Override
    public List getChildren() {
        return Arrays.asList(this._operands);
    }

    @Override
    public int getType() {
        return -3;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object r = this._operands[0].evaluate(context);
        if (r instanceof Boolean) {
            if (((Boolean)r).booleanValue() && this._operator == 89) {
                return r;
            }
            if (!((Boolean)r).booleanValue() && this._operator == 91) {
                return r;
            }
        }
        if (r == null || r == QueryService.UNDEFINED) {
            r = QueryService.UNDEFINED;
        } else if (!(r instanceof Boolean)) {
            throw new TypeMismatchException(String.format("LITERAL_and/LITERAL_or operands must be of type boolean, not type ' %s '", r.getClass().getName()));
        }
        for (int i = 1; i < this._operands.length; ++i) {
            Object ri = null;
            try {
                ri = this._operands[i].evaluate(context);
            }
            catch (EntryDestroyedException ede) {
                continue;
            }
            if (ri instanceof Boolean) {
                if (((Boolean)ri).booleanValue() && this._operator == 89) {
                    return ri;
                }
                if (!((Boolean)ri).booleanValue() && this._operator == 91) {
                    return ri;
                }
            }
            if (ri == null || ri == QueryService.UNDEFINED || r == QueryService.UNDEFINED) {
                r = QueryService.UNDEFINED;
                continue;
            }
            if (!(ri instanceof Boolean)) {
                throw new TypeMismatchException(String.format("LITERAL_and/LITERAL_or operands must be of type boolean, not type ' %s '", ri.getClass().getName()));
            }
            r = this._operator == 91 ? Boolean.valueOf((Boolean)r != false && (Boolean)ri != false) : Boolean.valueOf((Boolean)r != false || (Boolean)ri != false);
        }
        return r;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        for (int i = 0; i < this._operands.length; ++i) {
            context.addDependencies(this, this._operands[i].computeDependencies(context));
        }
        return context.getDependencySet(this, true);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        List unevaluatedOps;
        OrganizedOperands newOperands = this.organizeOperands(context);
        SelectResults result = intermediateResults;
        Support.Assert(newOperands.filterOperand != null);
        SelectResults selectResults = result = newOperands.isSingleFilter ? newOperands.filterOperand.filterEvaluate(context, result) : newOperands.filterOperand.auxFilterEvaluate(context, result);
        if (!newOperands.isSingleFilter && (unevaluatedOps = ((CompiledJunction)newOperands.filterOperand).unevaluatedFilterOperands) != null) {
            if (newOperands.iterateOperand == null) {
                if (unevaluatedOps.size() == 1) {
                    newOperands.iterateOperand = (CompiledValue)unevaluatedOps.get(0);
                } else {
                    int len = unevaluatedOps.size();
                    CompiledValue[] iterOps = new CompiledValue[len];
                    for (int i = 0; i < len; ++i) {
                        iterOps[i] = (CompiledValue)unevaluatedOps.get(i);
                    }
                    newOperands.iterateOperand = new CompiledJunction(iterOps, this.getOperator());
                }
            } else {
                if (newOperands.iterateOperand instanceof CompiledJunction) {
                    CompiledJunction temp = (CompiledJunction)newOperands.iterateOperand;
                    List prevOps = temp.getOperands();
                    unevaluatedOps.addAll(prevOps);
                } else {
                    unevaluatedOps.add(newOperands.iterateOperand);
                }
                int totalLen = unevaluatedOps.size();
                CompiledValue[] combinedOps = new CompiledValue[totalLen];
                Iterator itr = unevaluatedOps.iterator();
                int j = 0;
                while (itr.hasNext()) {
                    combinedOps[j++] = (CompiledValue)itr.next();
                }
                newOperands.iterateOperand = new CompiledJunction(combinedOps, this.getOperator());
            }
        }
        if (newOperands.iterateOperand != null) {
            result = this.auxIterateEvaluate(newOperands.iterateOperand, context, result);
        }
        return result;
    }

    private List getCondtionsSortedOnIncreasingEstimatedIndexResultSize(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int len = this._operands.length;
        ArrayList<Filter> sortedList = new ArrayList<Filter>(len);
        for (int i = 0; i < len; ++i) {
            Filter currSorted;
            int j;
            Filter toSort = (Filter)((Object)this._operands[i]);
            int indxRsltToSort = toSort.getSizeEstimate(context);
            int sortedListLen = sortedList.size();
            for (j = 0; j < sortedListLen && (currSorted = (Filter)sortedList.get(j)).getSizeEstimate(context) <= indxRsltToSort; ++j) {
            }
            sortedList.add(j, toSort);
        }
        return sortedList;
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        List sortedConditionsList = this.getCondtionsSortedOnIncreasingEstimatedIndexResultSize(context);
        Iterator sortedConditionsItr = sortedConditionsList.iterator();
        while (sortedConditionsItr.hasNext()) {
            SelectResults filterResults = ((Filter)sortedConditionsItr.next()).filterEvaluate(context, null);
            if (this._operator == 91) {
                if (filterResults != null && filterResults.isEmpty()) {
                    return filterResults;
                }
                if (filterResults == null) continue;
                intermediateResults = intermediateResults == null ? filterResults : QueryUtils.intersection(intermediateResults, filterResults, context);
                sortedConditionsItr.remove();
                if (intermediateResults.size() > indexThresholdSize) continue;
                break;
            }
            Assert.assertTrue(filterResults != null);
            intermediateResults = intermediateResults == null ? filterResults : QueryUtils.union(intermediateResults, filterResults, context);
        }
        if (this._operator == 91 && !sortedConditionsList.isEmpty()) {
            this.unevaluatedFilterOperands = sortedConditionsList;
        }
        return intermediateResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectResults auxIterateEvaluate(CompiledValue operand, ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (intermediateResults == null) {
            throw new RuntimeException("intermediateResults can not be null");
        }
        if (intermediateResults.isEmpty()) {
            return intermediateResults;
        }
        List currentIters = context.getCurrentIterators();
        RuntimeIterator[] rIters = new RuntimeIterator[currentIters.size()];
        currentIters.toArray(rIters);
        ObjectType elementType = intermediateResults.getCollectionType().getElementType();
        SelectResults resultSet = elementType.isStructType() ? QueryUtils.createStructCollection(context, (StructTypeImpl)elementType) : QueryUtils.createResultCollection(context, elementType);
        QueryObserver observer = QueryObserverHolder.getInstance();
        try {
            observer.startIteration(intermediateResults, operand);
            for (Object tuple : intermediateResults) {
                if (tuple instanceof Struct) {
                    Object[] values = ((Struct)tuple).getFieldValues();
                    for (int i = 0; i < values.length; ++i) {
                        rIters[i].setCurrent(values[i]);
                    }
                } else {
                    rIters[0].setCurrent(tuple);
                }
                Object result = null;
                try {
                    result = operand.evaluate(context);
                }
                finally {
                    observer.afterIterationEvaluation(result);
                }
                if (result instanceof Boolean) {
                    if (!((Boolean)result).booleanValue()) continue;
                    resultSet.add(tuple);
                    continue;
                }
                if (result == null || result == QueryService.UNDEFINED) continue;
                throw new TypeMismatchException(String.format("AND/OR operands must be of type boolean, not type ' %s '", result.getClass().getName()));
            }
        }
        finally {
            observer.endIteration(resultSet);
        }
        return resultSet;
    }

    @Override
    public void negate() {
        this._operator = this.inverseOperator(this._operator);
        for (int i = 0; i < this._operands.length; ++i) {
            if (this._operands[i] instanceof Negatable) {
                ((Negatable)((Object)this._operands[i])).negate();
                continue;
            }
            this._operands[i] = new CompiledNegation(this._operands[i]);
        }
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isOr;
        Support.Assert(this._operator == 89 || this._operator == 91);
        PlanInfo resultPlanInfo = new PlanInfo();
        resultPlanInfo.evalAsFilter = isOr = this._operator == 89;
        for (int i = 0; i < this._operands.length; ++i) {
            PlanInfo opPlanInfo = this._operands[i].getPlanInfo(context);
            resultPlanInfo.indexes.addAll(opPlanInfo.indexes);
            if (!isOr && opPlanInfo.evalAsFilter) {
                resultPlanInfo.evalAsFilter = true;
                continue;
            }
            if (!isOr || opPlanInfo.evalAsFilter) continue;
            resultPlanInfo.evalAsFilter = false;
        }
        return resultPlanInfo;
    }

    @Override
    public int getOperator() {
        return this._operator;
    }

    List getOperands() {
        return Collections.unmodifiableList(Arrays.asList(this._operands));
    }

    OrganizedOperands organizeOperands(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> evalOperands = new ArrayList<Object>(this._operands.length);
        int indexCount = 0;
        ArrayList<CompiledValue> compositeIterOperands = new ArrayList<CompiledValue>(this._operands.length);
        LinkedHashMap<CompiledValue, Set> compositeFilterOpsMap = new LinkedHashMap<CompiledValue, Set>();
        HashMap<RuntimeIterator, ArrayList<CompiledValue>> iterToOperands = new HashMap<RuntimeIterator, ArrayList<CompiledValue>>();
        CompiledValue operand = null;
        boolean isJunctionNeeded = false;
        boolean indexExistsOnNonJoinOp = false;
        for (int i = 0; i < this._operands.length; ++i) {
            operand = this._operands[i];
            if (!operand.isDependentOnCurrentScope(context)) {
                ++indexCount;
                evalOperands.add(0, operand);
                continue;
            }
            if (operand instanceof CompiledJunction) {
                if (operand.getPlanInfo((ExecutionContext)context).evalAsFilter) {
                    evalOperands.add(indexCount++, operand);
                    continue;
                }
                evalOperands.add(operand);
                continue;
            }
            CompiledValue[] expandedOperands = null;
            expandedOperands = operand.getType() == -15 && this._operator == 91 && ((CompiledLike)operand).getOperator() != 20 ? ((CompiledLike)operand).getExpandedOperandsWithIndexInfoSetIfAny(context) : new CompiledValue[]{operand};
            for (CompiledValue expndOperand : expandedOperands) {
                boolean operandEvalAsFilter = expndOperand.getPlanInfo((ExecutionContext)context).evalAsFilter;
                isJunctionNeeded = isJunctionNeeded || operandEvalAsFilter;
                Set set = QueryUtils.getCurrentScopeUltimateRuntimeIteratorsIfAny(expndOperand, context);
                if (set.size() != 1) {
                    if (operandEvalAsFilter) {
                        Support.Assert(set.size() == 2, " The no of independent iterators should be equal to 2");
                        compositeFilterOpsMap.put(expndOperand, set);
                        continue;
                    }
                    compositeIterOperands.add(expndOperand);
                    continue;
                }
                Support.Assert(set.size() == 1, "The size has to be 1 & cannot be zero as that would mean it is independent");
                RuntimeIterator rIter = (RuntimeIterator)set.iterator().next();
                ArrayList<CompiledValue> operandsList = (ArrayList<CompiledValue>)iterToOperands.get(rIter);
                if (operandsList == null) {
                    operandsList = new ArrayList<CompiledValue>();
                    iterToOperands.put(rIter, operandsList);
                }
                if (operandEvalAsFilter && this._operator == 91) {
                    indexExistsOnNonJoinOp = true;
                }
                operandsList.add(expndOperand);
            }
        }
        if (isJunctionNeeded) {
            Filter junction = this.createJunction(compositeIterOperands, compositeFilterOpsMap, iterToOperands, context, indexCount, evalOperands, indexExistsOnNonJoinOp);
            evalOperands.add(indexCount++, junction);
        } else {
            if (!compositeIterOperands.isEmpty()) {
                evalOperands.addAll(compositeIterOperands);
            }
            Iterator itr = iterToOperands.values().iterator();
            while (itr.hasNext()) {
                evalOperands.addAll((List)itr.next());
            }
        }
        OrganizedOperands result = new OrganizedOperands();
        Filter filterOperands = null;
        Support.Assert(indexCount > 0);
        if (indexCount == 1) {
            filterOperands = (Filter)evalOperands.get(0);
            result.isSingleFilter = true;
        } else {
            CompiledValue[] newOperands = new CompiledValue[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                newOperands[i] = (CompiledValue)evalOperands.get(i);
            }
            filterOperands = new CompiledJunction(newOperands, this._operator);
        }
        CompiledValue iterateOperands = null;
        int numIterating = evalOperands.size() - indexCount;
        Support.Assert(this._operator == 91 || numIterating == 0);
        if (numIterating > 0) {
            if (numIterating == 1) {
                iterateOperands = (CompiledValue)evalOperands.get(indexCount);
            } else {
                CompiledValue[] newOperands = new CompiledValue[numIterating];
                for (int i = 0; i < numIterating; ++i) {
                    newOperands[i] = (CompiledValue)evalOperands.get(i + indexCount);
                }
                iterateOperands = new CompiledJunction(newOperands, this._operator);
            }
        }
        result.filterOperand = filterOperands;
        result.iterateOperand = iterateOperands;
        return result;
    }

    private AbstractGroupOrRangeJunction createGroupJunctionOrRangeJunction(boolean needsCompacting, RuntimeIterator[] grpIndpndntItr, boolean completeExpnsn, CompiledValue[] cv, Map sameIndexOperands) {
        AbstractGroupOrRangeJunction junction;
        if (needsCompacting) {
            Iterator itr = sameIndexOperands.values().iterator();
            if (sameIndexOperands.size() == 1) {
                List sameIndexOps = (List)itr.next();
                Iterator sameIndexOpsItr = sameIndexOps.iterator();
                for (int i = 0; i < cv.length; ++i) {
                    if (cv[i] != null) continue;
                    cv[i] = (CompiledValue)sameIndexOpsItr.next();
                }
                junction = new RangeJunction(this._operator, grpIndpndntItr, completeExpnsn, cv);
            } else {
                int i;
                int numRangeJunctions = 0;
                CompiledValue[] rangeJunctions = new CompiledValue[sameIndexOperands.size()];
                int nullifiedFields = 0;
                while (itr.hasNext()) {
                    Object listOrPosition = itr.next();
                    if (!(listOrPosition instanceof List)) continue;
                    List ops = (List)listOrPosition;
                    nullifiedFields += ops.size();
                    CompiledValue[] operands = ops.toArray(new CompiledValue[0]);
                    rangeJunctions[numRangeJunctions++] = new RangeJunction(this._operator, grpIndpndntItr, completeExpnsn, operands);
                }
                int totalOperands = cv.length - nullifiedFields + numRangeJunctions;
                CompiledValue[] allOperands = new CompiledValue[totalOperands];
                int k = 0;
                for (i = 0; i < cv.length; ++i) {
                    CompiledValue tempCV = cv[i];
                    if (tempCV == null) continue;
                    allOperands[k++] = tempCV;
                }
                for (i = 0; i < numRangeJunctions; ++i) {
                    allOperands[k++] = rangeJunctions[i];
                }
                junction = new GroupJunction(this._operator, grpIndpndntItr, completeExpnsn, allOperands);
            }
        } else {
            junction = new GroupJunction(this._operator, grpIndpndntItr, completeExpnsn, cv);
        }
        return junction;
    }

    private boolean sortSameIndexOperandsForGroupJunction(CompiledValue[] cv, List operandsList, Map sameIndexOperands, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException, FunctionDomainException, QueryInvocationTargetException {
        int size = operandsList.size();
        CompiledValue tempOp = null;
        boolean needsCompacting = false;
        for (int i = 0; i < size; ++i) {
            tempOp = (CompiledValue)operandsList.get(i);
            IndexInfo[] indx = null;
            Object listOrPosition = null;
            boolean evalAsFilter = tempOp.getPlanInfo((ExecutionContext)context).evalAsFilter;
            if (evalAsFilter) {
                indx = ((Indexable)((Object)tempOp)).getIndexInfo(context);
                if (!IndexManager.JOIN_OPTIMIZATION || indx.length == 1) {
                    Assert.assertTrue(indx.length == 1, "There should have been just one index for the condition");
                    listOrPosition = sameIndexOperands.get(indx[0]._index);
                }
            }
            if (listOrPosition != null) {
                if (listOrPosition instanceof Integer) {
                    int position = listOrPosition;
                    ArrayList<CompiledValue> operands = new ArrayList<CompiledValue>(size);
                    operands.add(cv[position]);
                    operands.add(tempOp);
                    cv[position] = null;
                    sameIndexOperands.put(indx[0]._index, operands);
                    needsCompacting = true;
                } else if (listOrPosition instanceof List) {
                    List operands = listOrPosition;
                    operands.add(tempOp);
                } else {
                    listOrPosition = null;
                }
            }
            if (listOrPosition != null) continue;
            cv[i] = tempOp;
            if (indx != null && indx.length == 1) {
                if (!evalAsFilter || this._operator != 91) continue;
                sameIndexOperands.put(indx[0]._index, i);
                continue;
            }
            if (indx == null || indx.length != 2 || !evalAsFilter || this._operator != 91) continue;
            if (!sameIndexOperands.containsKey(indx[0]._index)) {
                sameIndexOperands.put(indx[0]._index, PLACEHOLDER_FOR_JOIN);
            }
            if (sameIndexOperands.containsKey(indx[1]._index)) continue;
            sameIndexOperands.put(indx[1]._index, PLACEHOLDER_FOR_JOIN);
        }
        return needsCompacting;
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.isDependentOnCurrentScope(context)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    private Filter createJunction(List compositeIterOperands, Map compositeFilterOpsMap, Map iterToOperands, ExecutionContext context, int indexCount, List evalOperands, boolean indexExistsOnNonJoinOp) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.Assert(!iterToOperands.isEmpty() || !compositeFilterOpsMap.isEmpty(), " There should not have been any need to create a Junction");
        AbstractCompiledValue junction = null;
        if (iterToOperands.size() == 1 && (compositeFilterOpsMap.isEmpty() || indexExistsOnNonJoinOp && IndexManager.JOIN_OPTIMIZATION)) {
            CompiledValue[] cv;
            if (indexExistsOnNonJoinOp && IndexManager.JOIN_OPTIMIZATION) {
                evalOperands.addAll(compositeFilterOpsMap.keySet());
            }
            Map.Entry entry = iterToOperands.entrySet().iterator().next();
            List operandsList = (List)entry.getValue();
            if (indexCount == 0) {
                operandsList.addAll(evalOperands);
                evalOperands.clear();
                if (!compositeIterOperands.isEmpty()) {
                    operandsList.addAll(compositeIterOperands);
                }
            } else {
                if (!compositeIterOperands.isEmpty()) {
                    evalOperands.addAll(compositeIterOperands);
                }
                Iterator itr = operandsList.iterator();
                while (itr.hasNext()) {
                    cv = (CompiledValue[])itr.next();
                    if (cv.getPlanInfo((ExecutionContext)context).evalAsFilter) continue;
                    itr.remove();
                    evalOperands.add(cv);
                }
            }
            int size = operandsList.size();
            HashMap sameIndexOperands = new HashMap(size);
            cv = new CompiledValue[size];
            boolean needsCompacting = this.sortSameIndexOperandsForGroupJunction(cv, operandsList, sameIndexOperands, context);
            junction = this.createGroupJunctionOrRangeJunction(needsCompacting, new RuntimeIterator[]{(RuntimeIterator)entry.getKey()}, true, cv, sameIndexOperands);
        } else {
            HashMap<RuntimeIterator, CompositeGroupJunction> tempMap = new HashMap<RuntimeIterator, CompositeGroupJunction>();
            Set entries = compositeFilterOpsMap.entrySet();
            HashSet<CompositeGroupJunction> cgjs = new HashSet<CompositeGroupJunction>(compositeFilterOpsMap.size());
            for (Map.Entry entry : entries) {
                CompiledValue op = (CompiledValue)entry.getKey();
                Set indpndtItrSet = (Set)entry.getValue();
                Iterator itr = indpndtItrSet.iterator();
                CompositeGroupJunction cgj = null;
                RuntimeIterator[] absentItrs = new RuntimeIterator[2];
                int k = 0;
                while (itr.hasNext()) {
                    RuntimeIterator ritr = (RuntimeIterator)itr.next();
                    CompositeGroupJunction temp = (CompositeGroupJunction)tempMap.get(ritr);
                    if (temp == null) {
                        absentItrs[k++] = ritr;
                    }
                    if (cgj == null && temp != null) {
                        cgj = temp;
                        cgj.addFilterableCompositeCondition(op);
                        continue;
                    }
                    if (cgj == null || temp == null || cgj == temp) continue;
                    cgj.mergeFilterableCCsAndIndependentItrs(temp);
                    cgjs.remove(temp);
                    Iterator entriesItr = tempMap.entrySet().iterator();
                    Map.Entry tempEntry = null;
                    while (entriesItr.hasNext()) {
                        tempEntry = entriesItr.next();
                        if (tempEntry.getValue() != temp) continue;
                        tempEntry.setValue(cgj);
                    }
                }
                if (cgj == null) {
                    cgj = new CompositeGroupJunction(this._operator, op);
                    cgjs.add(cgj);
                }
                for (int i = 0; i < k; ++i) {
                    tempMap.put(absentItrs[i], cgj);
                    cgj.addIndependentIterators(absentItrs[i]);
                }
            }
            ArrayList<AbstractCompiledValue> gjs = new ArrayList<AbstractCompiledValue>(iterToOperands.size());
            for (Map.Entry entry : iterToOperands.entrySet()) {
                List operandsList = (List)entry.getValue();
                int size = operandsList.size();
                CompiledValue[] cv = new CompiledValue[size];
                boolean evalAsFilter = false;
                boolean needsCompacting = false;
                CompiledValue tempOp = null;
                HashMap<IndexProtocol, Serializable> sameIndexOperands = new HashMap<IndexProtocol, Serializable>(size);
                for (int j = 0; j < size; ++j) {
                    tempOp = (CompiledValue)operandsList.get(j);
                    boolean isFilterevaluable = tempOp.getPlanInfo((ExecutionContext)context).evalAsFilter;
                    evalAsFilter = evalAsFilter || isFilterevaluable;
                    IndexInfo[] indx = null;
                    Object listOrPosition = null;
                    if (isFilterevaluable) {
                        indx = ((Indexable)((Object)tempOp)).getIndexInfo(context);
                        Assert.assertTrue(indx.length == 1, "There should have been just one index for the condition");
                        listOrPosition = sameIndexOperands.get(indx[0]._index);
                    }
                    if (listOrPosition != null) {
                        if (listOrPosition instanceof Integer) {
                            int position = listOrPosition;
                            ArrayList<CompiledValue> operands = new ArrayList<CompiledValue>(size);
                            operands.add(cv[position]);
                            operands.add(tempOp);
                            cv[position] = null;
                            sameIndexOperands.put(indx[0]._index, operands);
                            needsCompacting = true;
                            continue;
                        }
                        List operands = listOrPosition;
                        operands.add(tempOp);
                        continue;
                    }
                    cv[j] = tempOp;
                    if (!isFilterevaluable || this._operator != 91) continue;
                    sameIndexOperands.put(indx[0]._index, Integer.valueOf(j));
                }
                if (!evalAsFilter) {
                    List toAddTo = null;
                    toAddTo = indexCount > 0 ? evalOperands : compositeIterOperands;
                    for (int i = 0; i < size; ++i) {
                        toAddTo.add(cv[i]);
                    }
                    continue;
                }
                RuntimeIterator grpIndpndtItr = (RuntimeIterator)entry.getKey();
                AbstractGroupOrRangeJunction gj = this.createGroupJunctionOrRangeJunction(needsCompacting, new RuntimeIterator[]{(RuntimeIterator)entry.getKey()}, false, cv, sameIndexOperands);
                CompositeGroupJunction cgj = null;
                cgj = (CompositeGroupJunction)tempMap.get(grpIndpndtItr);
                if (cgj != null) {
                    cgj.addGroupOrRangeJunction(gj);
                    continue;
                }
                gjs.add(gj);
            }
            if (indexCount == 0) {
                compositeIterOperands.addAll(evalOperands);
                evalOperands.clear();
            } else if (!compositeIterOperands.isEmpty()) {
                evalOperands.addAll(compositeIterOperands);
            }
            Iterator cgjItr = cgjs.iterator();
            while (cgjItr.hasNext()) {
                ((CompositeGroupJunction)cgjItr.next()).setArrayOfIndependentItrs();
            }
            int cgjSize = cgjs.size();
            if (gjs.isEmpty() && cgjSize == 1) {
                CompositeGroupJunction compGrpJnc = (CompositeGroupJunction)cgjs.iterator().next();
                compGrpJnc.addIterOperands(compositeIterOperands);
                compGrpJnc.setCompleteExpansionOn();
                junction = compGrpJnc;
            } else if (gjs.size() == 1 && cgjSize == 0) {
                AbstractGroupOrRangeJunction gjTemp = (AbstractGroupOrRangeJunction)gjs.get(0);
                compositeIterOperands.addAll(gjTemp.getOperands());
                CompiledValue[] newOps = new CompiledValue[compositeIterOperands.size()];
                compositeIterOperands.toArray(newOps);
                junction = gjTemp.createNewOfSameType(this._operator, gjTemp.getIndependentIteratorForGroup(), true, newOps);
            } else {
                gjs.addAll(cgjs);
                junction = new AllGroupJunction(gjs, this._operator, compositeIterOperands);
            }
        }
        return junction;
    }

    OrganizedOperands testOrganizedOperands(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.organizeOperands(context);
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        for (int i = 0; i < this._operands.length; ++i) {
            if (this._operands[i].getType() != -3 && this._operands[i].getType() != -15 || !this._operands[i].getPlanInfo((ExecutionContext)context).evalAsFilter) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this._operator == 89) {
            for (int i = 0; i < this._operands.length; ++i) {
                if (this._operands[i].getPlanInfo((ExecutionContext)context).evalAsFilter && !((Filter)((Object)this._operands[i])).isLimitApplicableAtIndexLevel(context)) continue;
                return false;
            }
            return true;
        }
        boolean foundIndex = false;
        for (int i = 0; i < this._operands.length; ++i) {
            if (this._operands[i].getPlanInfo((ExecutionContext)context).evalAsFilter && this._operands[i].getType() == -3) {
                return false;
            }
            if (!this._operands[i].getPlanInfo((ExecutionContext)context).evalAsFilter) continue;
            foundIndex = true;
        }
        return foundIndex;
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this._operator == 91) {
            boolean foundRightIndex = false;
            for (int i = 0; i < this._operands.length; ++i) {
                IndexProtocol ip;
                PlanInfo pi = this._operands[i].getPlanInfo(context);
                if (pi.evalAsFilter && this._operands[i].getType() == -3) {
                    return false;
                }
                if (!pi.evalAsFilter || foundRightIndex || !(ip = (IndexProtocol)this._operands[i].getPlanInfo((ExecutionContext)context).indexes.get(0)).getCanonicalizedIndexedExpression().equals(canonicalizedOrderByClause) || !pi.isPreferred) continue;
                foundRightIndex = true;
            }
            return foundRightIndex;
        }
        return false;
    }
}

