/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.pdx.internal.PdxString;

public class CompiledBindArgument
extends AbstractCompiledValue {
    private int index;

    public CompiledBindArgument(int index) {
        this.index = index;
    }

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (context.isBindArgsSet()) {
            Object bindArgumentValue = context.getBindArgument(this.index);
            if (bindArgumentValue instanceof Region) {
                clauseBuffer.insert(0, ((Region)bindArgumentValue).getFullPath());
            } else if (bindArgumentValue instanceof String) {
                clauseBuffer.insert(0, '\'').insert(0, bindArgumentValue).insert(0, '\'');
            } else {
                super.generateCanonicalizedExpression(clauseBuffer, context);
            }
        }
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        PartitionedRegion pr;
        if (!context.isBindArgsSet()) {
            return null;
        }
        Object obj = context.getBindArgument(this.index);
        if (obj instanceof Region && (pr = context.getPartitionedRegion()) != null && pr.getFullPath().equals(((Region)obj).getFullPath())) {
            obj = context.getBucketRegion();
        }
        return obj;
    }

    public Object evaluate(Object[] bindArguments) {
        if (this.index > bindArguments.length) {
            throw new IllegalArgumentException("Too few query parameters");
        }
        return bindArguments[this.index - 1];
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        Object v = parameters[this.index - 1];
        if (v instanceof Region) {
            regionsInQuery.add(((Region)v).getFullPath());
        }
    }

    public PdxString getSavedPdxString(ExecutionContext context) {
        return context.getSavedPdxString(this.index);
    }
}

