/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.List;
import org.apache.geode.cache.query.IndexType;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class IndexTypeConverter
implements Converter<IndexType> {
    @Override
    public boolean supports(Class<?> type, String optionContext) {
        return IndexType.class.isAssignableFrom(type) && optionContext.contains("geode.converter.index.type:disable-enum-converter");
    }

    @Override
    public IndexType convertFromText(String value, Class<?> targetType, String optionContext) {
        switch (value.toLowerCase()) {
            case "range": {
                return IndexType.FUNCTIONAL;
            }
            case "key": {
                return IndexType.PRIMARY_KEY;
            }
            case "hash": {
                return IndexType.HASH;
            }
        }
        throw new IllegalArgumentException("invalid index type: " + value);
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        completions.add(new Completion("range"));
        completions.add(new Completion("key"));
        completions.add(new Completion("hash"));
        return true;
    }
}

