/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionAccounting {
    private final int minimum;
    private final int maximum;
    private final AtomicInteger count = new AtomicInteger();

    public ConnectionAccounting(int min, int max) {
        this.minimum = min;
        this.maximum = max;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getCount() {
        return this.count.get();
    }

    public boolean tryPrefill() {
        return this.tryReserve(this.minimum);
    }

    public void cancelTryPrefill() {
        this.count.getAndDecrement();
    }

    public boolean tryCreate() {
        return this.tryReserve(this.maximum);
    }

    public void cancelTryCreate() {
        this.count.decrementAndGet();
    }

    public void create() {
        this.count.getAndIncrement();
    }

    public boolean tryDestroy() {
        int currentCount;
        while ((currentCount = this.count.get()) > this.maximum) {
            if (!this.count.compareAndSet(currentCount, currentCount - 1)) continue;
            return true;
        }
        return false;
    }

    public void cancelTryDestroy() {
        this.count.getAndIncrement();
    }

    public boolean destroyAndIsUnderMinimum(int destroyCount) {
        int newCount = this.count.addAndGet(-destroyCount);
        return newCount < this.minimum;
    }

    public boolean isUnderMinimum() {
        return this.count.get() < this.minimum;
    }

    public boolean isOverMinimum() {
        return this.count.get() > this.minimum;
    }

    private boolean tryReserve(int upperBound) {
        int currentCount;
        while ((currentCount = this.count.get()) < upperBound) {
            if (!this.count.compareAndSet(currentCount, currentCount + 1)) continue;
            return true;
        }
        return false;
    }
}

