/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.internal.distributed.CollectorManager;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.cache.lucene.internal.distributed.TopEntries;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.repository.IndexResultCollector;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TopEntriesCollectorManager
implements CollectorManager<TopEntriesCollector>,
DataSerializableFixedID {
    private static final Logger logger = LogService.getLogger();
    private int limit;
    private String id;

    public TopEntriesCollectorManager() {
        this(null, 0);
    }

    public TopEntriesCollectorManager(String id) {
        this(id, 0);
    }

    public TopEntriesCollectorManager(String id, int resultLimit) {
        this.limit = resultLimit <= 0 ? 100 : resultLimit;
        this.id = id == null ? String.valueOf(this.hashCode()) : id;
        logger.debug("Max count of entries to be produced by {} is {}", (Object)id, (Object)this.limit);
    }

    @Override
    public TopEntriesCollector newCollector(String name) {
        return new TopEntriesCollector(name, this.limit);
    }

    @Override
    public TopEntriesCollector reduce(Collection<TopEntriesCollector> collectors) {
        TopEntriesCollector mergedResult = new TopEntriesCollector(this.id, this.limit);
        if (collectors.isEmpty()) {
            return mergedResult;
        }
        TopEntries.EntryScoreComparator scoreComparator = new TopEntries.EntryScoreComparator(new TopEntries());
        Comparator entryListComparator = (l1, l2) -> {
            EntryScore o1 = l1.peek();
            EntryScore o2 = l2.peek();
            return scoreComparator.compare(o1, o2);
        };
        PriorityQueue entryListsPriorityQueue = new PriorityQueue(collectors.size(), Collections.reverseOrder(entryListComparator));
        for (IndexResultCollector indexResultCollector : collectors) {
            logger.debug("Number of entries found in collector {} is {}", (Object)indexResultCollector.getName(), (Object)indexResultCollector.size());
            if (indexResultCollector.size() <= 0) continue;
            entryListsPriorityQueue.add(new ListScanner(((TopEntriesCollector)indexResultCollector).getEntries().getHits()));
        }
        logger.debug("Only {} count of entries will be reduced. Other entries will be ignored", (Object)this.limit);
        while (entryListsPriorityQueue.size() > 0 && this.limit > mergedResult.size()) {
            ListScanner scanner = (ListScanner)entryListsPriorityQueue.remove();
            EntryScore entryScore = scanner.next();
            mergedResult.collect(entryScore);
            if (!scanner.hasNext()) continue;
            entryListsPriorityQueue.add(scanner);
        }
        logger.debug("Reduced size of {} is {}", (Object)mergedResult.getName(), (Object)mergedResult.size());
        return mergedResult;
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2173;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        out.writeInt(this.limit);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.limit = in.readInt();
    }

    public String getId() {
        return this.id;
    }

    public int getLimit() {
        return this.limit;
    }

    static class ListScanner {
        private final List<EntryScore> hits;
        private int index = 0;

        ListScanner(List<EntryScore> hits) {
            this.hits = hits;
        }

        boolean hasNext() {
            return this.index < this.hits.size();
        }

        EntryScore peek() {
            return this.hits.get(this.index);
        }

        EntryScore next() {
            return this.hits.get(this.index++);
        }
    }
}

