/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class BitCountExecutor
extends StringExecutor {
    private static final String ERROR_NOT_INT = "The indexes provided must be numeric values";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long result;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        if (commandElems.size() == 4) {
            int end;
            int start;
            try {
                start = Math.toIntExact(Coder.bytesToLong(commandElems.get(2)));
                end = Math.toIntExact(Coder.bytesToLong(commandElems.get(3)));
            }
            catch (NumberFormatException e) {
                return RedisResponse.error(ERROR_NOT_INT);
            }
            catch (ArithmeticException ex) {
                return RedisResponse.error("The number provided is out of range");
            }
            result = stringCommands.bitcount(key, start, end);
        } else {
            result = stringCommands.bitcount(key);
        }
        return RedisResponse.integer(result);
    }
}

