/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.geode.management.internal.FederationComponent;

public class LongStatsDeltaAggregator {
    private AtomicLongArray prevCounters;
    private AtomicLongArray currCounters;
    private List<String> keys;

    public LongStatsDeltaAggregator(List<String> keys) {
        this.keys = keys;
        this.prevCounters = new AtomicLongArray(keys.size());
        this.currCounters = new AtomicLongArray(keys.size());
        this.initializeArray(this.currCounters);
    }

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.incData(newState, oldState);
    }

    private void incData(FederationComponent newComp, FederationComponent oldComp) {
        Map<String, Object> oldState;
        Map<String, Object> newState;
        Map<String, Object> map = newState = newComp != null ? newComp.getObjectState() : null;
        if (oldComp != null && oldComp.getOldState().size() > 0) {
            oldState = oldComp.getOldState();
        } else {
            Map<String, Object> map2 = oldState = oldComp != null ? oldComp.getObjectState() : null;
        }
        if (newState != null) {
            for (int index = 0; index < this.keys.size(); ++index) {
                Object val;
                this.prevCounters.set(index, this.currCounters.get(index));
                Long newVal = (Long)newState.get(this.keys.get(index));
                if (newVal == null) continue;
                Long oldVal = 0L;
                if (oldState != null && (val = oldState.get(this.keys.get(index))) != null) {
                    oldVal = (Long)val;
                }
                this.currCounters.addAndGet(index, newVal - oldVal);
            }
        }
    }

    public long getDelta(String key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return 0L;
        }
        return this.currCounters.get(this.keys.indexOf(key)) - this.prevCounters.get(this.keys.indexOf(key));
    }

    private void initializeArray(AtomicLongArray arr) {
        for (int i = 0; i < arr.length(); ++i) {
            arr.set(i, 0L);
        }
    }
}

