/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;

class LocalProcessLauncher {
    static final String PROPERTY_IGNORE_IS_PID_ALIVE = "gemfire.test.LocalProcessLauncher.ignoreIsPidAlive";
    private final int pid;
    private final File pidFile;

    LocalProcessLauncher(File pidFile, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        Validate.notNull((Object)pidFile, (String)("Invalid pidFile '" + pidFile + "' specified"), (Object[])new Object[0]);
        this.pid = ProcessUtils.identifyPid();
        this.pidFile = pidFile;
        this.writePid(force);
    }

    int getPid() {
        return this.pid;
    }

    File getPidFile() {
        return this.pidFile;
    }

    void close() {
        this.pidFile.delete();
    }

    void close(boolean deletePidFileOnClose) {
        if (deletePidFileOnClose) {
            this.pidFile.delete();
        }
    }

    private void writePid(boolean force) throws FileAlreadyExistsException, IOException {
        if (this.pidFile.exists()) {
            if (!force) {
                this.checkOtherPid(this.readOtherPid());
            }
            this.pidFile.delete();
        }
        File tempPidFile = new File(this.pidFile.getParent(), this.pidFile.getName() + ".tmp");
        tempPidFile.createNewFile();
        try (FileWriter writer = new FileWriter(tempPidFile);){
            writer.write(String.valueOf(this.pid));
            writer.flush();
        }
        tempPidFile.renameTo(this.pidFile);
        this.pidFile.deleteOnExit();
    }

    private int readOtherPid() {
        int otherPid = 0;
        try {
            otherPid = ProcessUtils.readPid(this.pidFile);
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return otherPid;
    }

    private void checkOtherPid(int otherPid) throws FileAlreadyExistsException {
        if (LocalProcessLauncher.ignoreIsPidAlive() || otherPid != 0 && this.isProcessAlive(otherPid)) {
            throw new FileAlreadyExistsException("Pid file already exists: " + this.pidFile + " for " + (otherPid > 0 ? "process " + otherPid : "unknown process"));
        }
    }

    private boolean isProcessAlive(int pid) {
        return LocalProcessLauncher.ignoreIsPidAlive() || ProcessUtils.isProcessAlive(pid);
    }

    private static boolean ignoreIsPidAlive() {
        return Boolean.getBoolean(PROPERTY_IGNORE_IS_PID_ALIVE);
    }
}

