/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GatewaySenderEventCallbackDispatcher
implements GatewaySenderEventDispatcher {
    private static final Logger logger = LogService.getLogger();
    protected final AbstractGatewaySenderEventProcessor eventProcessor;
    private volatile List<AsyncEventListener> eventListeners = Collections.emptyList();
    private final Object eventLock = new Object();

    public GatewaySenderEventCallbackDispatcher(AbstractGatewaySenderEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
        this.initializeEventListeners();
    }

    @Override
    public boolean dispatchBatch(List events, boolean removeFromQueueOnException, boolean isRetry) {
        GatewaySenderStats statistics = this.eventProcessor.sender.getStatistics();
        boolean success = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("About to dispatch batch");
            }
            long start = statistics.startTime();
            success = this.dispatchBatch(events);
            statistics.endBatch(start, events.size());
            if (logger.isDebugEnabled()) {
                logger.debug("Done dispatching the batch");
            }
        }
        catch (GatewaySenderException start) {
        }
        catch (CancelException e) {
            this.eventProcessor.setIsStopped(true);
            throw e;
        }
        catch (Exception e) {
            logger.fatal("Stopping the processor because the following exception occurred while processing a batch:", (Throwable)e);
            this.eventProcessor.setIsStopped(true);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsyncEventListener(AsyncEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            List<AsyncEventListener> oldListeners = this.eventListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<AsyncEventListener> newListeners = new ArrayList<AsyncEventListener>(oldListeners);
                newListeners.add(listener);
                this.eventListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterGatewayEventListener(AsyncEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            ArrayList<AsyncEventListener> newListeners;
            List<AsyncEventListener> oldListeners = this.eventListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList<AsyncEventListener>(oldListeners)).remove(listener)) {
                this.eventListeners = newListeners;
            }
        }
    }

    protected void initializeEventListeners() {
        for (AsyncEventListener listener : this.eventProcessor.getSender().getAsyncEventListeners()) {
            this.registerAsyncEventListener(listener);
        }
    }

    protected boolean dispatchBatch(List events) throws GatewaySenderException {
        if (events.isEmpty()) {
            return true;
        }
        int batchId = this.eventProcessor.getBatchId();
        boolean successAll = true;
        try {
            for (AsyncEventListener listener : this.eventListeners) {
                boolean successOne = listener.processEvents(events);
                if (successOne) continue;
                successAll = false;
            }
        }
        catch (Exception e) {
            String alias = "%s: Exception during processing batch %s";
            Object[] aliasArgs = new Object[]{this, batchId};
            String exMsg = String.format("%s: Exception during processing batch %s", aliasArgs);
            GatewaySenderException ge = new GatewaySenderException(exMsg, e);
            logger.warn(exMsg, (Throwable)ge);
            throw ge;
        }
        return successAll;
    }

    @Override
    public boolean isRemoteDispatcher() {
        return false;
    }

    @Override
    public boolean isConnectedToRemote() {
        return false;
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutDownAckReaderConnection() {
    }
}

