/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.set.DeltaSet;

class SremFunction
implements Function<ArrayList<ByteArrayWrapper>> {
    public static final String ID = "SREM_FUNCTION";

    SremFunction() {
    }

    public void execute(FunctionContext<ArrayList<ByteArrayWrapper>> context) {
        RegionFunctionContextImpl regionFunctionContext = (RegionFunctionContextImpl)context;
        ByteArrayWrapper key = (ByteArrayWrapper)regionFunctionContext.getFilter().iterator().next();
        Region localRegion = regionFunctionContext.getLocalDataSet(regionFunctionContext.getDataSet());
        ArrayList membersToRemove = (ArrayList)regionFunctionContext.getArguments();
        AtomicBoolean setWasDeleted = new AtomicBoolean();
        long membersRemoved = DeltaSet.srem((Region<ByteArrayWrapper, DeltaSet>)localRegion, key, membersToRemove, setWasDeleted);
        ResultSender resultSender = regionFunctionContext.getResultSender();
        resultSender.sendResult((Object)membersRemoved);
        resultSender.lastResult((Object)(setWasDeleted.get() ? 1L : 0L));
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public String getId() {
        return ID;
    }
}

