/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SRandMemberExecutor
extends SetExecutor {
    private static final String ERROR_NOT_NUMERIC = "The count provided must be numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        block39: {
            List<byte[]> commandElems = command.getProcessedCommand();
            if (commandElems.size() < 2) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SRANDMEMBER command is \"SRANDMEMBER key [count]\""));
                return;
            }
            ByteArrayWrapper key = command.getKey();
            try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
                Set<ByteArrayWrapper> set;
                Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
                int count = 1;
                if (commandElems.size() > 2) {
                    try {
                        count = Coder.bytesToInt(commandElems.get(2));
                    }
                    catch (NumberFormatException e) {
                        command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_NOT_NUMERIC));
                        if (regionLock != null) {
                            if (var6_8 != null) {
                                try {
                                    regionLock.close();
                                }
                                catch (Throwable throwable) {
                                    var6_8.addSuppressed(throwable);
                                }
                            } else {
                                regionLock.close();
                            }
                        }
                        return;
                    }
                }
                if ((set = DeltaSet.members(region, key)) == null || count == 0) {
                    command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
                    return;
                }
                int members = set.size();
                if (members <= count && count != 1) {
                    this.respondBulkStrings(command, context, new HashSet<ByteArrayWrapper>(set));
                    return;
                }
                Random rand = new Random();
                ByteArrayWrapper[] entries = set.toArray(new ByteArrayWrapper[members]);
                try {
                    if (count == 1) {
                        ByteArrayWrapper randEntry = entries[rand.nextInt(entries.length)];
                        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), randEntry.toBytes()));
                        break block39;
                    }
                    if (count > 0) {
                        HashSet<ByteArrayWrapper> randEntries = new HashSet<ByteArrayWrapper>();
                        do {
                            ByteArrayWrapper s = entries[rand.nextInt(entries.length)];
                            randEntries.add(s);
                        } while (randEntries.size() < count);
                        command.setResponse(Coder.getArrayResponse(context.getByteBufAllocator(), randEntries));
                        break block39;
                    }
                    count = -count;
                    ArrayList<ByteArrayWrapper> randEntries = new ArrayList<ByteArrayWrapper>();
                    for (int i = 0; i < count; ++i) {
                        ByteArrayWrapper s = entries[rand.nextInt(entries.length)];
                        randEntries.add(s);
                    }
                    command.setResponse(Coder.getArrayResponse(context.getByteBufAllocator(), randEntries));
                }
                catch (CoderException e) {
                    command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
                return;
            }
            catch (TimeoutException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
                return;
            }
        }
    }
}

