/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SMoveExecutor
extends SetExecutor {
    private static final int MOVED = 1;
    private static final int NOT_MOVED = 0;

    /*
     * Loose catch block
     */
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        block47: {
            List<byte[]> commandElems = command.getProcessedCommand();
            if (commandElems.size() != 4) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SMOVE command is \"SMOVE source destination member\""));
                return;
            }
            ByteArrayWrapper source = command.getKey();
            ByteArrayWrapper destination = new ByteArrayWrapper(commandElems.get(2));
            ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(3));
            this.checkDataType(source, RedisDataType.REDIS_SET, context);
            this.checkDataType(destination, RedisDataType.REDIS_SET, context);
            Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
            try {
                Throwable throwable = null;
                try (AutoCloseableLock regionLock = this.withRegionLock(context, source);){
                    boolean removed;
                    DeltaSet sourceSet = (DeltaSet)region.get((Object)source);
                    if (sourceSet == null) {
                        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                        return;
                    }
                    boolean bl = removed = DeltaSet.srem(region, source, new ArrayList<ByteArrayWrapper>(Collections.singletonList(member)), null) == 1L;
                    if (!removed) {
                        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                        break block47;
                    }
                    try (AutoCloseableLock destinationLock = this.withRegionLock(context, destination);){
                        DeltaSet.sadd(region, destination, new ArrayList<ByteArrayWrapper>(Collections.singletonList(member)));
                        context.getKeyRegistrar().register(destination, RedisDataType.REDIS_SET);
                        context.getKeyRegistrar().register(source, RedisDataType.REDIS_SET);
                        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        System.out.println("Interrupt exception!!");
                        command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
                        if (regionLock != null) {
                            if (throwable != null) {
                                try {
                                    regionLock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                regionLock.close();
                            }
                        }
                        return;
                    }
                    catch (TimeoutException e) {
                        block48: {
                            block49: {
                                System.out.println("Timeout exception!!");
                                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
                                if (regionLock == null) break block48;
                                if (throwable == null) break block49;
                                try {
                                    regionLock.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block48;
                            }
                            regionLock.close();
                        }
                        return;
                    }
                    catch (Exception e) {
                        System.out.println("Unexpected exception: " + e);
                        command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Unexpected exception."));
                        break block47;
                        {
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throw throwable5;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("Interrupt exception!!");
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
                return;
            }
            catch (TimeoutException e) {
                System.out.println("Timeout exception!!");
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
                return;
            }
            catch (Exception e) {
                System.out.println("Unexpected exception: " + e);
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Unexpected exception."));
            }
        }
    }
}

