/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.VersionedThinDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedThinDiskLRURegionEntryHeapStringKey1
extends VersionedThinDiskLRURegionEntryHeap {
    private static final AtomicLongFieldUpdater<VersionedThinDiskLRURegionEntryHeapStringKey1> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VersionedThinDiskLRURegionEntryHeapStringKey1.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    protected DiskId id;
    private VersionSource memberId;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long bits1;
    private EvictionNode nextEvictionNode;
    private EvictionNode previousEvictionNode;
    private int size;

    public VersionedThinDiskLRURegionEntryHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tempBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tempBits1 <<= 8;
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)key.charAt(i);
                tempBits1 <<= 16;
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        boolean isBackup;
        if (context instanceof InternalRegion) {
            isBackup = ((InternalRegion)context).getDiskRegion().isBackup();
        } else if (context instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a InternalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(context, value);
        }
    }

    @Override
    public synchronized int updateAsyncEntrySize(EvictionController evictionController) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    public void setDiskId(RegionEntry oldEntry) {
        this.id = ((DiskEntry)oldEntry).getDiskId();
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore diskRecoveryStore = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, diskStore.needsLinkedList());
        DiskEntry.Helper.initialize(this, diskRecoveryStore, value);
    }

    @Override
    public void setDelayedDiskId(DiskRecoveryStore diskRecoveryStore) {
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, diskStore.needsLinkedList());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController) {
        return this.updateEntrySize(evictionController, this.getValue());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean isRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
        if (!this.isRecentlyUsed()) {
            this.setBits(0x1000000000000000L);
            context.incRecentlyUsed();
        }
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean isEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNext(EvictionNode nextEvictionNode) {
        this.nextEvictionNode = nextEvictionNode;
    }

    @Override
    public EvictionNode next() {
        return this.nextEvictionNode;
    }

    @Override
    public void setPrevious(EvictionNode previousEvictionNode) {
        this.previousEvictionNode = previousEvictionNode;
    }

    @Override
    public EvictionNode previous() {
        return this.previousEvictionNode;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long timeStamp) {
        this.setLastModified(timeStamp);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberId;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag versionTag) {
        this.memberId = versionTag.getMemberID();
        int eVersion = versionTag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = versionTag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = versionTag.getRegionVersionLowBytes();
        if (!versionTag.isGatewayTag() && this.distributedSystemId == versionTag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= versionTag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
            } else {
                versionTag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(versionTag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberId) {
        this.memberId = memberId;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberId);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(InternalRegion region, VersionTag versionTag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource versionSource, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(region, versionTag, isTombstoneFromGII, hasDelta, versionSource, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 8) & 0xFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

