/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import org.hbase.async.HBaseClient;
import org.hbase.async.RegionClient;
import org.hbase.async.SecureRpcHelper;
import org.hbase.async.generated.RPCPB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecureRpcHelper96
extends SecureRpcHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecureRpcHelper96.class);
    final byte[] connection_header;

    public SecureRpcHelper96(HBaseClient hbase_client, RegionClient region_client, SocketAddress remote_endpoint) {
        super(hbase_client, region_client, remote_endpoint);
        this.connection_header = new byte[]{72, 66, 97, 115, 0, this.client_auth_provider.getAuthMethodCode()};
    }

    @Override
    public void sendHello(Channel channel) {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])this.connection_header);
        Channels.write((Channel)channel, (Object)buffer);
        if (this.sasl_client != null) {
            byte[] challenge_bytes = null;
            if (this.sasl_client.hasInitialResponse()) {
                challenge_bytes = this.processChallenge(new byte[0]);
            }
            if (challenge_bytes != null) {
                byte[] buf = new byte[4 + challenge_bytes.length];
                buffer = ChannelBuffers.wrappedBuffer((byte[])buf);
                buffer.clear();
                buffer.writeInt(challenge_bytes.length);
                buffer.writeBytes(challenge_bytes);
                Channels.write((Channel)channel, (Object)buffer);
            } else {
                LOG.error("Missing initial Sasl response on client " + (Object)((Object)this.region_client));
            }
        } else {
            this.sendRPCHeader(channel);
        }
    }

    @Override
    public ChannelBuffer handleResponse(ChannelBuffer buf, Channel chan) {
        if (this.sasl_client == null) {
            return buf;
        }
        if (!this.sasl_client.isComplete()) {
            int state = buf.readInt();
            if (state != 0) {
                if (buf.readableBytes() < 8) {
                    throw new SecurityException("Sasl initialization failed with a status of [" + state + "] and an unknown exception. " + "Check HBase logs.: " + this);
                }
                int len = buf.readInt();
                byte[] temp = new byte[len];
                buf.readBytes(temp);
                String exception = new String(temp);
                len = buf.readInt();
                temp = new byte[len];
                buf.readBytes(temp);
                String msg = new String(temp);
                throw new SecurityException("Sasl initialization failed with a status of [" + state + "] and exception [" + exception + "] and message [" + msg + "]: " + this);
            }
            int len = buf.readInt();
            byte[] b = new byte[len];
            buf.readBytes(b);
            byte[] challenge_bytes = this.processChallenge(b);
            if (challenge_bytes != null) {
                byte[] out_bytes = new byte[4 + challenge_bytes.length];
                ChannelBuffer out_buffer = ChannelBuffers.wrappedBuffer((byte[])out_bytes);
                out_buffer.clear();
                out_buffer.writeInt(challenge_bytes.length);
                out_buffer.writeBytes(challenge_bytes);
                Channels.write((Channel)chan, (Object)out_buffer);
            }
            if (this.sasl_client.isComplete()) {
                String qop = (String)this.sasl_client.getNegotiatedProperty("javax.security.sasl.qop");
                LOG.info("SASL client context established. Negotiated QoP: " + qop + " on for: " + (Object)((Object)this.region_client));
                this.sendRPCHeader(chan);
            }
            return null;
        }
        return this.unwrap(buf);
    }

    private void sendRPCHeader(Channel chan) {
        RPCPB.UserInformation user = RPCPB.UserInformation.newBuilder().setEffectiveUser(this.client_auth_provider.getClientUsername()).build();
        RPCPB.ConnectionHeader pb = RPCPB.ConnectionHeader.newBuilder().setUserInfo(user).setServiceName("ClientService").setCellBlockCodecClass("org.apache.hadoop.hbase.codec.KeyValueCodec").build();
        int pblen = pb.getSerializedSize();
        byte[] buf = new byte[4 + pblen];
        ChannelBuffer header = ChannelBuffers.wrappedBuffer((byte[])buf);
        header.clear();
        header.writeInt(pblen);
        try {
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])buf, (int)4, (int)pblen);
            pb.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
        header.writerIndex(buf.length);
        Channels.write((Channel)chan, (Object)this.wrap(header));
        this.region_client.becomeReady(chan, (byte)95);
    }
}

