/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.filesystem.FileSystems;
import org.apache.flink.table.store.spark.SparkCaseSensitiveConverter;
import org.apache.flink.table.store.spark.SparkDataSourceReader;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.types.StructType;

public class SparkSource
implements DataSourceRegister,
ReadSupport,
SessionConfigSupport {
    private static final String SHORT_NAME = "tablestore";

    public String shortName() {
        return SHORT_NAME;
    }

    public DataSourceReader createReader(StructType schema, DataSourceOptions options) {
        return this.createReader(options);
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Configuration configuration = Configuration.fromMap(SparkCaseSensitiveConverter.convert(options));
        FileSystems.initialize(CoreOptions.path(configuration), configuration);
        return new SparkDataSourceReader(FileStoreTableFactory.create(configuration));
    }

    public String keyPrefix() {
        return SHORT_NAME;
    }
}

