/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.resourcemanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;

public abstract class AbstractResourceManagerHandler<T extends RestfulGateway, R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends AbstractRestHandler<T, R, P, M> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    protected AbstractResourceManagerHandler(GatewayRetriever<? extends T> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<R, P, M> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.resourceManagerGatewayRetriever = Preconditions.checkNotNull(resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<P> handleRequest(@Nonnull HandlerRequest<R> request, @Nonnull T gateway) throws RestHandlerException {
        ResourceManagerGateway resourceManagerGateway = AbstractResourceManagerHandler.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        return this.handleRequest(request, resourceManagerGateway);
    }

    @Override
    protected abstract CompletableFuture<P> handleRequest(@Nonnull HandlerRequest<R> var1, @Nonnull ResourceManagerGateway var2) throws RestHandlerException;

    public static ResourceManagerGateway getResourceManagerGateway(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) throws RestHandlerException {
        return resourceManagerGatewayRetriever.getNow().orElseThrow(() -> new RestHandlerException("Cannot connect to ResourceManager right now. Please try to refresh.", HttpResponseStatus.NOT_FOUND));
    }
}

