/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public final class IncompleteFuturesTracker {
    private final ReentrantLock lock = new ReentrantLock();
    private final HashSet<CompletableFuture<?>> incompleteFutures = new HashSet();
    @Nullable
    private Throwable failureCause;

    public void trackFutureWhileIncomplete(CompletableFuture<?> future) {
        if (future.isDone()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.failureCause != null) {
                future.completeExceptionally(this.failureCause);
                return;
            }
            this.incompleteFutures.add(future);
        }
        finally {
            this.lock.unlock();
        }
        future.whenComplete((success, failure) -> this.removeFromSet(future));
    }

    public Collection<CompletableFuture<?>> getCurrentIncompleteAndReset() {
        this.lock.lock();
        try {
            if (this.incompleteFutures.isEmpty()) {
                Set<CompletableFuture<?>> set = Collections.emptySet();
                return set;
            }
            ArrayList futures = new ArrayList(this.incompleteFutures);
            this.incompleteFutures.clear();
            ArrayList arrayList = futures;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void failAllFutures(Throwable cause) {
        ArrayList futuresToFail;
        this.lock.lock();
        try {
            if (this.failureCause != null) {
                return;
            }
            this.failureCause = cause;
            futuresToFail = new ArrayList(this.incompleteFutures);
            this.incompleteFutures.clear();
        }
        finally {
            this.lock.unlock();
        }
        for (CompletableFuture completableFuture : futuresToFail) {
            completableFuture.completeExceptionally(cause);
        }
    }

    void removeFromSet(CompletableFuture<?> future) {
        this.lock.lock();
        try {
            this.incompleteFutures.remove(future);
        }
        finally {
            this.lock.unlock();
        }
    }
}

