/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.IteratorRecordReader;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.TableScan;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.flink.table.types.logical.RowType;

public class OptionsTable
implements Table {
    private static final long serialVersionUID = 1L;
    public static final String OPTIONS = "options";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new RowType.RowField("key", SerializationUtils.newStringType(false)), new RowType.RowField("value", SerializationUtils.newStringType(false))));
    private final Path location;

    public OptionsTable(Path location) {
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + OPTIONS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public Path location() {
        return this.location;
    }

    @Override
    public TableScan newScan() {
        return new OptionsScan();
    }

    @Override
    public TableRead newRead() {
        return new OptionsRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new OptionsTable(this.location);
    }

    private static Map<String, String> options(Path location) {
        return new SchemaManager(location).latest().orElseThrow(() -> new RuntimeException("Table not exists.")).options();
    }

    private static class OptionsRead
    implements TableRead {
        private int[][] projection;

        private OptionsRead() {
        }

        @Override
        public TableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public RecordReader<RowData> createReader(Split split) throws IOException {
            if (!(split instanceof OptionsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((OptionsSplit)split).location;
            Iterator rows = Iterators.transform(OptionsTable.options(location).entrySet().iterator(), this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRowData.from(this.projection).replaceRow((RowData)row));
            }
            return new IteratorRecordReader<RowData>(rows);
        }

        private RowData toRow(Map.Entry<String, String> option) {
            return GenericRowData.of(StringData.fromString(option.getKey()), StringData.fromString(option.getValue()));
        }
    }

    private static class OptionsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private OptionsSplit(Path location) {
            this.location = location;
        }

        @Override
        public long rowCount() {
            return OptionsTable.options(this.location).size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionsSplit that = (OptionsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class OptionsScan
    implements TableScan {
        private OptionsScan() {
        }

        @Override
        public TableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            return () -> Collections.singletonList(new OptionsSplit(OptionsTable.this.location));
        }
    }
}

