/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class DecimalColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        DecimalColumnStatsDataInspector aggregateData = (DecimalColumnStatsDataInspector)aggregateColStats.getStatsData().getDecimalStats();
        DecimalColumnStatsDataInspector newData = (DecimalColumnStatsDataInspector)newColStats.getStatsData().getDecimalStats();
        Decimal lowValue = this.getMin(aggregateData.getLowValue(), newData.getLowValue());
        aggregateData.setLowValue(lowValue);
        Decimal highValue = this.getMax(aggregateData.getHighValue(), newData.getHighValue());
        aggregateData.setHighValue(highValue);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            NumDistinctValueEstimator oldEst = aggregateData.getNdvEstimator();
            NumDistinctValueEstimator newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge(newEst)) {
                oldEst.mergeEstimators(newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator(oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
    }

    Decimal getMax(Decimal firstValue, Decimal secondValue) {
        if (firstValue == null && secondValue == null) {
            return null;
        }
        if (firstValue != null && secondValue != null) {
            return firstValue.compareTo(secondValue) > 0 ? firstValue : secondValue;
        }
        return firstValue == null ? secondValue : firstValue;
    }

    Decimal getMin(Decimal firstValue, Decimal secondValue) {
        if (firstValue == null && secondValue == null) {
            return null;
        }
        if (firstValue != null && secondValue != null) {
            return firstValue.compareTo(secondValue) > 0 ? secondValue : firstValue;
        }
        return firstValue == null ? secondValue : firstValue;
    }
}

