/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.fm.FMSketchUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HyperLogLogUtils;

public class NumDistinctValueEstimatorFactory {
    private NumDistinctValueEstimatorFactory() {
    }

    private static boolean isFMSketch(byte[] buf) throws IOException {
        byte[] magic = new byte[]{buf[0], buf[1]};
        return Arrays.equals(magic, FMSketchUtils.MAGIC);
    }

    public static NumDistinctValueEstimator getNumDistinctValueEstimator(byte[] buf) {
        try {
            if (NumDistinctValueEstimatorFactory.isFMSketch(buf)) {
                return FMSketchUtils.deserializeFM(buf);
            }
            return HyperLogLogUtils.deserializeHLL(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NumDistinctValueEstimator getEmptyNumDistinctValueEstimator(NumDistinctValueEstimator n) {
        if (n instanceof FMSketch) {
            return new FMSketch(((FMSketch)n).getNumBitVectors());
        }
        return HyperLogLog.builder().setSizeOptimized().build();
    }

    public static NumDistinctValueEstimator getEmptyNumDistinctValueEstimator(String func, int numBitVectors) {
        if ("fm".equals(func.toLowerCase())) {
            return new FMSketch(numBitVectors);
        }
        if ("hll".equals(func.toLowerCase())) {
            return HyperLogLog.builder().setSizeOptimized().build();
        }
        throw new RuntimeException("Can not recognize " + func);
    }
}

