/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.internals.NoAvailableBrokersException;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.errors.RetriableException;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;

public class RequestFuture<T>
implements ConsumerNetworkClient.PollCondition {
    private static final Object INCOMPLETE_SENTINEL = new Object();
    private final AtomicReference<Object> result = new AtomicReference<Object>(INCOMPLETE_SENTINEL);
    private final ConcurrentLinkedQueue<RequestFutureListener<T>> listeners = new ConcurrentLinkedQueue();
    private final CountDownLatch completedLatch = new CountDownLatch(1);

    public boolean isDone() {
        return this.result.get() != INCOMPLETE_SENTINEL;
    }

    public boolean awaitDone(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completedLatch.await(timeout, unit);
    }

    public T value() {
        if (!this.succeeded()) {
            throw new IllegalStateException("Attempt to retrieve value from future which hasn't successfully completed");
        }
        return (T)this.result.get();
    }

    public boolean succeeded() {
        return this.isDone() && !this.failed();
    }

    public boolean failed() {
        return this.result.get() instanceof RuntimeException;
    }

    public boolean isRetriable() {
        return this.exception() instanceof RetriableException;
    }

    public RuntimeException exception() {
        if (!this.failed()) {
            throw new IllegalStateException("Attempt to retrieve exception from future which hasn't failed");
        }
        return (RuntimeException)this.result.get();
    }

    public void complete(T value) {
        try {
            if (value instanceof RuntimeException) {
                throw new IllegalArgumentException("The argument to complete can not be an instance of RuntimeException");
            }
            if (!this.result.compareAndSet(INCOMPLETE_SENTINEL, value)) {
                throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
            }
            this.fireSuccess();
        }
        finally {
            this.completedLatch.countDown();
        }
    }

    public void raise(RuntimeException e) {
        try {
            if (e == null) {
                throw new IllegalArgumentException("The exception passed to raise must not be null");
            }
            if (!this.result.compareAndSet(INCOMPLETE_SENTINEL, e)) {
                throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
            }
            this.fireFailure();
        }
        finally {
            this.completedLatch.countDown();
        }
    }

    public void raise(Errors error) {
        this.raise(error.exception());
    }

    private void fireSuccess() {
        RequestFutureListener<T> listener;
        T value = this.value();
        while ((listener = this.listeners.poll()) != null) {
            listener.onSuccess(value);
        }
    }

    private void fireFailure() {
        RequestFutureListener<T> listener;
        RuntimeException exception = this.exception();
        while ((listener = this.listeners.poll()) != null) {
            listener.onFailure(exception);
        }
    }

    public void addListener(RequestFutureListener<T> listener) {
        this.listeners.add(listener);
        if (this.failed()) {
            this.fireFailure();
        } else if (this.succeeded()) {
            this.fireSuccess();
        }
    }

    public <S> RequestFuture<S> compose(final RequestFutureAdapter<T, S> adapter) {
        final RequestFuture<T> adapted = new RequestFuture<T>();
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value) {
                adapter.onSuccess(value, adapted);
            }

            @Override
            public void onFailure(RuntimeException e) {
                adapter.onFailure(e, adapted);
            }
        });
        return adapted;
    }

    public void chain(final RequestFuture<T> future) {
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value) {
                future.complete(value);
            }

            @Override
            public void onFailure(RuntimeException e) {
                future.raise(e);
            }
        });
    }

    public static <T> RequestFuture<T> failure(RuntimeException e) {
        RequestFuture<T> future = new RequestFuture<T>();
        future.raise(e);
        return future;
    }

    public static RequestFuture<Void> voidSuccess() {
        RequestFuture<Void> future = new RequestFuture<Void>();
        future.complete(null);
        return future;
    }

    public static <T> RequestFuture<T> coordinatorNotAvailable() {
        return RequestFuture.failure(Errors.COORDINATOR_NOT_AVAILABLE.exception());
    }

    public static <T> RequestFuture<T> noBrokersAvailable() {
        return RequestFuture.failure(new NoAvailableBrokersException());
    }

    @Override
    public boolean shouldBlock() {
        return !this.isDone();
    }
}

