/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public class UpdateSchema {
    private final RowType rowType;
    private final List<String> partitionKeys;
    private final List<String> primaryKeys;
    private final Map<String, String> options;
    private final String comment;

    public UpdateSchema(RowType rowType, List<String> partitionKeys, List<String> primaryKeys, Map<String, String> options, String comment) {
        this.rowType = this.validateRowType(rowType, primaryKeys, partitionKeys);
        this.partitionKeys = partitionKeys;
        this.primaryKeys = primaryKeys;
        this.options = new HashMap<String, String>(options);
        this.comment = comment;
    }

    public RowType rowType() {
        return this.rowType;
    }

    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public String comment() {
        return this.comment;
    }

    private RowType validateRowType(RowType rowType, List<String> primaryKeys, List<String> partitionKeys) {
        List fieldNames = rowType.getFieldNames();
        HashSet allFields = new HashSet(fieldNames);
        Preconditions.checkState((boolean)allFields.containsAll(partitionKeys), (String)"Table column %s should include all partition fields %s", (Object[])new Object[]{fieldNames, partitionKeys});
        if (primaryKeys.isEmpty()) {
            return rowType;
        }
        Preconditions.checkState((boolean)allFields.containsAll(primaryKeys), (String)"Table column %s should include all primary key constraint %s", (Object[])new Object[]{fieldNames, primaryKeys});
        HashSet<String> pkSet = new HashSet<String>(primaryKeys);
        Preconditions.checkState((boolean)pkSet.containsAll(partitionKeys), (String)"Primary key constraint %s should include all partition fields %s", (Object[])new Object[]{primaryKeys, partitionKeys});
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        for (RowType.RowField field : rowType.getFields()) {
            if (pkSet.contains(field.getName()) && field.getType().isNullable()) {
                fields.add(new RowType.RowField(field.getName(), field.getType().copy(false), (String)field.getDescription().orElse(null)));
                continue;
            }
            fields.add(field);
        }
        return new RowType(false, fields);
    }

    public String toString() {
        return "UpdateSchema{rowType=" + this.rowType + ", partitionKeys=" + this.partitionKeys + ", primaryKeys=" + this.primaryKeys + ", options=" + this.options + ", comment=" + this.comment + '}';
    }

    public CatalogTableImpl toCatalogTable() {
        TableSchema schema;
        HashMap<String, String> newOptions = new HashMap<String, String>(this.options);
        DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
        tableSchemaProps.putProperties(newOptions);
        Optional optional = tableSchemaProps.getOptionalTableSchema("schema");
        if (optional.isPresent()) {
            schema = (TableSchema)optional.get();
            DescriptorProperties removeProperties = new DescriptorProperties(false);
            removeProperties.putTableSchema("schema", schema);
            removeProperties.asMap().keySet().forEach(newOptions::remove);
        } else {
            TableSchema.Builder builder = TableSchema.builder();
            for (RowType.RowField field : this.rowType.getFields()) {
                builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
            }
            if (this.primaryKeys.size() > 0) {
                builder.primaryKey(this.primaryKeys.toArray(new String[0]));
            }
            schema = builder.build();
        }
        return new CatalogTableImpl(schema, this.partitionKeys, newOptions, this.comment);
    }

    public static UpdateSchema fromCatalogTable(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        RowType rowType = (RowType)schema.toPhysicalRowDataType().getLogicalType();
        ArrayList<String> primaryKeys = new ArrayList();
        if (schema.getPrimaryKey().isPresent()) {
            primaryKeys = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        }
        HashMap<String, String> options = new HashMap<String, String>(catalogTable.getOptions());
        if (schema.getTableColumns().stream().anyMatch(c -> !c.isPhysical()) || schema.getWatermarkSpecs().size() > 0) {
            DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
            tableSchemaProps.putTableSchema("schema", schema);
            options.putAll(tableSchemaProps.asMap());
        }
        return new UpdateSchema(rowType, catalogTable.getPartitionKeys(), primaryKeys, options, catalogTable.getComment());
    }
}

