/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.compact;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.compact.CompactManager;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.util.Preconditions;

public class NoopCompactManager
implements CompactManager {
    @Override
    public boolean shouldWaitCompaction() {
        return false;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        Preconditions.checkArgument((!fullCompaction ? 1 : 0) != 0, (Object)("NoopCompactManager does not support user triggered compaction.\nIf you really need a guaranteed compaction, please set " + CoreOptions.WRITE_ONLY.key() + " property of this table to false."));
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        return Optional.empty();
    }

    @Override
    public void cancelCompaction() {
    }
}

