/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.cleanup;

import java.util.concurrent.Executor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.dispatcher.cleanup.CleanupRetryStrategyFactory;
import org.apache.flink.runtime.dispatcher.cleanup.DefaultResourceCleaner;
import org.apache.flink.runtime.dispatcher.cleanup.GloballyCleanableResource;
import org.apache.flink.runtime.dispatcher.cleanup.LocallyCleanableResource;
import org.apache.flink.runtime.dispatcher.cleanup.ResourceCleaner;
import org.apache.flink.runtime.dispatcher.cleanup.ResourceCleanerFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.RetryStrategy;

public class DispatcherResourceCleanerFactory
implements ResourceCleanerFactory {
    private static final String JOB_MANAGER_RUNNER_REGISTRY_LABEL = "JobManagerRunnerRegistry";
    private static final String JOB_GRAPH_STORE_LABEL = "JobGraphStore";
    private static final String BLOB_SERVER_LABEL = "BlobServer";
    private static final String HA_SERVICES_LABEL = "HighAvailabilityServices";
    private static final String JOB_MANAGER_METRIC_GROUP_LABEL = "JobManagerMetricGroup";
    private final Executor cleanupExecutor;
    private final RetryStrategy retryStrategy;
    private final JobManagerRunnerRegistry jobManagerRunnerRegistry;
    private final JobGraphWriter jobGraphWriter;
    private final BlobServer blobServer;
    private final HighAvailabilityServices highAvailabilityServices;
    private final JobManagerMetricGroup jobManagerMetricGroup;

    public DispatcherResourceCleanerFactory(JobManagerRunnerRegistry jobManagerRunnerRegistry, DispatcherServices dispatcherServices) {
        this(dispatcherServices.getIoExecutor(), CleanupRetryStrategyFactory.INSTANCE.createRetryStrategy(dispatcherServices.getConfiguration()), jobManagerRunnerRegistry, dispatcherServices.getJobGraphWriter(), dispatcherServices.getBlobServer(), dispatcherServices.getHighAvailabilityServices(), dispatcherServices.getJobManagerMetricGroup());
    }

    @VisibleForTesting
    public DispatcherResourceCleanerFactory(Executor cleanupExecutor, RetryStrategy retryStrategy, JobManagerRunnerRegistry jobManagerRunnerRegistry, JobGraphWriter jobGraphWriter, BlobServer blobServer, HighAvailabilityServices highAvailabilityServices, JobManagerMetricGroup jobManagerMetricGroup) {
        this.cleanupExecutor = Preconditions.checkNotNull(cleanupExecutor);
        this.retryStrategy = retryStrategy;
        this.jobManagerRunnerRegistry = Preconditions.checkNotNull(jobManagerRunnerRegistry);
        this.jobGraphWriter = Preconditions.checkNotNull(jobGraphWriter);
        this.blobServer = Preconditions.checkNotNull(blobServer);
        this.highAvailabilityServices = Preconditions.checkNotNull(highAvailabilityServices);
        this.jobManagerMetricGroup = Preconditions.checkNotNull(jobManagerMetricGroup);
    }

    @Override
    public ResourceCleaner createLocalResourceCleaner(ComponentMainThreadExecutor mainThreadExecutor) {
        return DefaultResourceCleaner.forLocallyCleanableResources(mainThreadExecutor, this.cleanupExecutor, this.retryStrategy).withPrioritizedCleanup(JOB_MANAGER_RUNNER_REGISTRY_LABEL, this.jobManagerRunnerRegistry).withRegularCleanup(JOB_GRAPH_STORE_LABEL, this.jobGraphWriter).withRegularCleanup(BLOB_SERVER_LABEL, this.blobServer).withRegularCleanup(JOB_MANAGER_METRIC_GROUP_LABEL, this.jobManagerMetricGroup).build();
    }

    @Override
    public ResourceCleaner createGlobalResourceCleaner(ComponentMainThreadExecutor mainThreadExecutor) {
        return DefaultResourceCleaner.forGloballyCleanableResources(mainThreadExecutor, this.cleanupExecutor, this.retryStrategy).withPrioritizedCleanup(JOB_MANAGER_RUNNER_REGISTRY_LABEL, DispatcherResourceCleanerFactory.ofLocalResource(this.jobManagerRunnerRegistry)).withRegularCleanup(JOB_GRAPH_STORE_LABEL, this.jobGraphWriter).withRegularCleanup(BLOB_SERVER_LABEL, this.blobServer).withRegularCleanup(HA_SERVICES_LABEL, this.highAvailabilityServices).withRegularCleanup(JOB_MANAGER_METRIC_GROUP_LABEL, DispatcherResourceCleanerFactory.ofLocalResource(this.jobManagerMetricGroup)).build();
    }

    private static GloballyCleanableResource ofLocalResource(LocallyCleanableResource localResource) {
        return localResource::localCleanupAsync;
    }
}

