/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRawValueData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.NestedRowData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class RowDataUtils {
    public static RowData copyRowData(RowData row, RowType rowType) {
        if (row instanceof BinaryRowData) {
            return ((BinaryRowData)row).copy();
        }
        if (row instanceof NestedRowData) {
            return ((NestedRowData)row).copy();
        }
        GenericRowData ret = new GenericRowData(row.getArity());
        ret.setRowKind(row.getRowKind());
        for (int i = 0; i < row.getArity(); ++i) {
            LogicalType fieldType = rowType.getTypeAt(i);
            ret.setField(i, RowDataUtils.copy(RowDataUtils.get(row, i, fieldType), fieldType));
        }
        return ret;
    }

    public static ArrayData copyArray(ArrayData from, LogicalType eleType) {
        if (from instanceof BinaryArrayData) {
            return ((BinaryArrayData)from).copy();
        }
        if (!eleType.isNullable()) {
            switch (eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArrayData(from.toBooleanArray());
                }
                case TINYINT: {
                    return new GenericArrayData(from.toByteArray());
                }
                case SMALLINT: {
                    return new GenericArrayData(from.toShortArray());
                }
                case INTEGER: 
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: {
                    return new GenericArrayData(from.toIntArray());
                }
                case BIGINT: {
                    return new GenericArrayData(from.toLongArray());
                }
                case FLOAT: {
                    return new GenericArrayData(from.toFloatArray());
                }
                case DOUBLE: {
                    return new GenericArrayData(from.toDoubleArray());
                }
            }
        }
        Object[] newArray = new Object[from.size()];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = !from.isNullAt(i) ? RowDataUtils.copy(RowDataUtils.get(from, i, eleType), eleType) : null;
        }
        return new GenericArrayData(newArray);
    }

    private static MapData copyMap(MapData map, LogicalType keyType, LogicalType valueType) {
        if (map instanceof BinaryMapData) {
            return ((BinaryMapData)map).copy();
        }
        HashMap<Object, Object> javaMap = new HashMap<Object, Object>();
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        for (int i = 0; i < keys.size(); ++i) {
            javaMap.put(RowDataUtils.copy(RowDataUtils.get(keys, i, keyType), keyType), RowDataUtils.copy(RowDataUtils.get(values, i, valueType), valueType));
        }
        return new GenericMapData(javaMap);
    }

    public static Object copy(Object o, LogicalType type) {
        if (o instanceof StringData) {
            BinaryStringData string = (BinaryStringData)o;
            return string.getBinarySection() == null ? StringData.fromString((String)string.toString()) : ((BinaryStringData)o).copy();
        }
        if (o instanceof RowData) {
            return RowDataUtils.copyRowData((RowData)o, (RowType)type);
        }
        if (o instanceof ArrayData) {
            return RowDataUtils.copyArray((ArrayData)o, ((ArrayType)type).getElementType());
        }
        if (o instanceof MapData) {
            if (type instanceof MapType) {
                return RowDataUtils.copyMap((MapData)o, ((MapType)type).getKeyType(), ((MapType)type).getValueType());
            }
            return RowDataUtils.copyMap((MapData)o, ((MultisetType)type).getElementType(), (LogicalType)new IntType());
        }
        if (o instanceof RawValueData) {
            BinaryRawValueData raw = (BinaryRawValueData)o;
            if (raw.getBinarySection() != null) {
                return BinaryRawValueData.fromBytes((byte[])raw.toBytes(null));
            }
        } else if (o instanceof DecimalData) {
            return ((DecimalData)o).copy();
        }
        return o;
    }

    public static Object get(RowData row, int pos, LogicalType fieldType) {
        if (row.isNullAt(pos)) {
            return null;
        }
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return row.getBoolean(pos);
            }
            case TINYINT: {
                return row.getByte(pos);
            }
            case SMALLINT: {
                return row.getShort(pos);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return row.getInt(pos);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return row.getLong(pos);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)fieldType;
                return row.getTimestamp(pos, timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)fieldType;
                return row.getTimestamp(pos, lzTs.getPrecision());
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(pos));
            }
            case DOUBLE: {
                return row.getDouble(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return row.getString(pos);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return row.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                return row.getArray(pos);
            }
            case MAP: 
            case MULTISET: {
                return row.getMap(pos);
            }
            case ROW: {
                return row.getRow(pos, ((RowType)fieldType).getFieldCount());
            }
            case BINARY: 
            case VARBINARY: {
                return row.getBinary(pos);
            }
            case RAW: {
                return row.getRawValue(pos);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    public static Object get(ArrayData array, int pos, LogicalType fieldType) {
        if (array.isNullAt(pos)) {
            return null;
        }
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return array.getBoolean(pos);
            }
            case TINYINT: {
                return array.getByte(pos);
            }
            case SMALLINT: {
                return array.getShort(pos);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return array.getInt(pos);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return array.getLong(pos);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)fieldType;
                return array.getTimestamp(pos, timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)fieldType;
                return array.getTimestamp(pos, lzTs.getPrecision());
            }
            case FLOAT: {
                return Float.valueOf(array.getFloat(pos));
            }
            case DOUBLE: {
                return array.getDouble(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return array.getString(pos);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return array.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                return array.getArray(pos);
            }
            case MAP: 
            case MULTISET: {
                return array.getMap(pos);
            }
            case ROW: {
                return array.getRow(pos, ((RowType)fieldType).getFieldCount());
            }
            case BINARY: 
            case VARBINARY: {
                return array.getBinary(pos);
            }
            case RAW: {
                return array.getRawValue(pos);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    public static ArrayData toStringArrayData(List<String> list) {
        return new GenericArrayData(list.stream().map(StringData::fromString).toArray());
    }

    public static List<String> fromStringArrayData(ArrayData arrayData) {
        ArrayList<String> list = new ArrayList<String>(arrayData.size());
        for (int i = 0; i < arrayData.size(); ++i) {
            list.add(arrayData.isNullAt(i) ? null : arrayData.getString(i).toString());
        }
        return list;
    }

    public static long castToIntegral(DecimalData dec) {
        BigDecimal bd = dec.toBigDecimal();
        bd = bd.setScale(0, RoundingMode.DOWN);
        return bd.longValue();
    }

    public static RowData.FieldGetter createNullCheckingFieldGetter(LogicalType logicalType, int index) {
        RowData.FieldGetter getter = RowData.createFieldGetter((LogicalType)logicalType, (int)index);
        if (logicalType.isNullable()) {
            return getter;
        }
        return (RowData.FieldGetter & Serializable)row -> {
            if (row.isNullAt(index)) {
                return null;
            }
            return getter.getFieldOrNull(row);
        };
    }
}

