/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.datastream.sort;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.configuration.AlgorithmOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.ml.common.datastream.sort.FixedLengthByteKeyComparator;
import org.apache.flink.ml.common.datastream.sort.KeyAndValueSerializer;
import org.apache.flink.ml.common.datastream.sort.VariableLengthByteKeyComparator;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.ExternalSorter;
import org.apache.flink.runtime.operators.sort.NonReusingSortMergeCoGroupIterator;
import org.apache.flink.runtime.operators.sort.PushSorter;
import org.apache.flink.runtime.operators.sort.ReusingSortMergeCoGroupIterator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;

public class CoGroupOperator<IN1, IN2, KEY extends Serializable, OUT>
extends AbstractUdfStreamOperator<OUT, CoGroupFunction<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
BoundedMultiInput {
    private PushSorter<Tuple2<byte[], StreamRecord<IN1>>> sorterA;
    private PushSorter<Tuple2<byte[], StreamRecord<IN2>>> sorterB;
    private TypeComparator<Tuple2<byte[], StreamRecord<IN1>>> comparatorA;
    private TypeComparator<Tuple2<byte[], StreamRecord<IN2>>> comparatorB;
    private KeySelector<IN1, KEY> keySelectorA;
    private KeySelector<IN2, KEY> keySelectorB;
    private TypeSerializer<Tuple2<byte[], StreamRecord<IN1>>> keyAndValueSerializerA;
    private TypeSerializer<Tuple2<byte[], StreamRecord<IN2>>> keyAndValueSerializerB;
    private TypeSerializer<KEY> keySerializer;
    private DataOutputSerializer dataOutputSerializer;
    private long lastWatermarkTimestamp = Long.MIN_VALUE;
    private int remainingInputNum = 2;

    public CoGroupOperator(CoGroupFunction<IN1, IN2, OUT> function) {
        super(function);
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        super.setup(containingTask, config, output);
        ClassLoader userCodeClassLoader = containingTask.getUserCodeClassLoader();
        MemoryManager memoryManager = containingTask.getEnvironment().getMemoryManager();
        IOManager ioManager = containingTask.getEnvironment().getIOManager();
        this.keySelectorA = config.getStatePartitioner(0, userCodeClassLoader);
        this.keySelectorB = config.getStatePartitioner(1, userCodeClassLoader);
        this.keySerializer = config.getStateKeySerializer(userCodeClassLoader);
        int keyLength = this.keySerializer.getLength();
        TypeSerializer typeSerializerA = config.getTypeSerializerIn(0, userCodeClassLoader);
        TypeSerializer typeSerializerB = config.getTypeSerializerIn(1, userCodeClassLoader);
        this.keyAndValueSerializerA = new KeyAndValueSerializer<IN1>(typeSerializerA, keyLength);
        this.keyAndValueSerializerB = new KeyAndValueSerializer<IN2>(typeSerializerB, keyLength);
        if (keyLength > 0) {
            this.dataOutputSerializer = new DataOutputSerializer(keyLength);
            this.comparatorA = new FixedLengthByteKeyComparator<IN1>(keyLength);
            this.comparatorB = new FixedLengthByteKeyComparator<IN2>(keyLength);
        } else {
            this.dataOutputSerializer = new DataOutputSerializer(64);
            this.comparatorA = new VariableLengthByteKeyComparator<IN1>();
            this.comparatorB = new VariableLengthByteKeyComparator<IN2>();
        }
        ExecutionConfig executionConfig = containingTask.getEnvironment().getExecutionConfig();
        double managedMemoryFraction = config.getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, containingTask.getEnvironment().getTaskConfiguration(), userCodeClassLoader) / 2.0;
        Configuration jobConfiguration = containingTask.getEnvironment().getJobConfiguration();
        try {
            this.sorterA = ExternalSorter.newBuilder((MemoryManager)memoryManager, containingTask, this.keyAndValueSerializerA, this.comparatorA, (ExecutionConfig)executionConfig).memoryFraction(managedMemoryFraction).enableSpilling(ioManager, (double)((Float)jobConfiguration.get(AlgorithmOptions.SORT_SPILLING_THRESHOLD)).floatValue()).maxNumFileHandles(((Integer)jobConfiguration.get(AlgorithmOptions.SPILLING_MAX_FAN)).intValue()).objectReuse(executionConfig.isObjectReuseEnabled()).largeRecords(((Boolean)jobConfiguration.get(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER)).booleanValue()).build();
            this.sorterB = ExternalSorter.newBuilder((MemoryManager)memoryManager, containingTask, this.keyAndValueSerializerB, this.comparatorB, (ExecutionConfig)executionConfig).memoryFraction(managedMemoryFraction).enableSpilling(ioManager, (double)((Float)jobConfiguration.get(AlgorithmOptions.SORT_SPILLING_THRESHOLD)).floatValue()).maxNumFileHandles(((Integer)jobConfiguration.get(AlgorithmOptions.SPILLING_MAX_FAN)).intValue()).objectReuse(executionConfig.isObjectReuseEnabled()).largeRecords(((Boolean)jobConfiguration.get(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER)).booleanValue()).build();
        }
        catch (MemoryAllocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void endInput(int inputId) throws Exception {
        if (inputId == 1) {
            this.sorterA.finishReading();
            --this.remainingInputNum;
        } else if (inputId == 2) {
            this.sorterB.finishReading();
            --this.remainingInputNum;
        } else {
            throw new RuntimeException("Unknown inputId " + inputId);
        }
        if (this.remainingInputNum > 0) {
            return;
        }
        MutableObjectIterator iteratorA = this.sorterA.getIterator();
        MutableObjectIterator iteratorB = this.sorterB.getIterator();
        TypePairComparator pairComparator = new RuntimePairComparatorFactory().createComparator12(this.comparatorA, this.comparatorB);
        Object coGroupIterator = this.getExecutionConfig().isObjectReuseEnabled() ? new ReusingSortMergeCoGroupIterator(iteratorA, iteratorB, this.keyAndValueSerializerA, this.comparatorA, this.keyAndValueSerializerB, this.comparatorB, pairComparator) : new NonReusingSortMergeCoGroupIterator(iteratorA, iteratorB, this.keyAndValueSerializerA, this.comparatorA, this.keyAndValueSerializerB, this.comparatorB, pairComparator);
        coGroupIterator.open();
        TupleUnwrappingIterator unWrappediteratorA = new TupleUnwrappingIterator();
        TupleUnwrappingIterator unWrappediteratorB = new TupleUnwrappingIterator();
        TimestampedCollector timestampedCollector = new TimestampedCollector(this.output);
        while (coGroupIterator.next()) {
            unWrappediteratorA.set(coGroupIterator.getValues1().iterator());
            unWrappediteratorB.set(coGroupIterator.getValues2().iterator());
            ((CoGroupFunction)this.userFunction).coGroup(unWrappediteratorA, unWrappediteratorB, (Collector)timestampedCollector);
        }
        coGroupIterator.close();
        Watermark watermark = new Watermark(this.lastWatermarkTimestamp);
        if (this.getTimeServiceManager().isPresent()) {
            ((InternalTimeServiceManager)this.getTimeServiceManager().get()).advanceWatermark(watermark);
        }
        this.output.emitWatermark(watermark);
    }

    public void processWatermark(Watermark watermark) throws Exception {
        if (this.lastWatermarkTimestamp > watermark.getTimestamp()) {
            throw new RuntimeException("Invalid watermark");
        }
        this.lastWatermarkTimestamp = watermark.getTimestamp();
    }

    public void close() throws Exception {
        super.close();
        this.sorterA.close();
        this.sorterB.close();
    }

    public void processElement1(StreamRecord<IN1> streamRecord) throws Exception {
        Serializable key = (Serializable)this.keySelectorA.getKey(streamRecord.getValue());
        this.keySerializer.serialize((Object)key, (DataOutputView)this.dataOutputSerializer);
        byte[] serializedKey = this.dataOutputSerializer.getCopyOfBuffer();
        this.dataOutputSerializer.clear();
        this.sorterA.writeRecord((Object)Tuple2.of((Object)serializedKey, streamRecord));
    }

    public void processElement2(StreamRecord<IN2> streamRecord) throws Exception {
        Serializable key = (Serializable)this.keySelectorB.getKey(streamRecord.getValue());
        this.keySerializer.serialize((Object)key, (DataOutputView)this.dataOutputSerializer);
        byte[] serializedKey = this.dataOutputSerializer.getCopyOfBuffer();
        this.dataOutputSerializer.clear();
        this.sorterB.writeRecord((Object)Tuple2.of((Object)serializedKey, streamRecord));
    }

    private static class TupleUnwrappingIterator<T, K>
    implements Iterator<T>,
    Iterable<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private K lastKey;
        private Iterator<Tuple2<K, StreamRecord<T>>> iterator;
        private boolean iteratorAvailable;

        private TupleUnwrappingIterator() {
        }

        public void set(Iterator<Tuple2<K, StreamRecord<T>>> iterator) {
            this.iterator = iterator;
            this.iteratorAvailable = true;
        }

        public K getLastKey() {
            return this.lastKey;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            Tuple2<K, StreamRecord<T>> t = this.iterator.next();
            this.lastKey = t.f0;
            return (T)((StreamRecord)t.f1).getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iteratorAvailable) {
                this.iteratorAvailable = false;
                return this;
            }
            throw new TraversableOnceException();
        }
    }
}

