/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.statefun.flink.common.UnimplementedTypeInfo;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.RoutableMessage;
import org.apache.flink.statefun.flink.core.translation.DecoratedSource;
import org.apache.flink.statefun.flink.core.translation.IngressToSourceFunctionTranslator;
import org.apache.flink.statefun.flink.core.translation.RouterTranslator;
import org.apache.flink.statefun.flink.core.types.StaticallyRegisteredTypes;
import org.apache.flink.statefun.sdk.io.IngressIdentifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

final class Sources {
    private final DataStream<Message> sourceUnion;

    private Sources(DataStream<Message> union) {
        this.sourceUnion = union;
    }

    static Sources create(StreamExecutionEnvironment env, StatefulFunctionsUniverse universe, StatefulFunctionsConfig configuration) {
        Map<IngressIdentifier<?>, DecoratedSource> sourceFunctions = Sources.ingressToSourceFunction(universe);
        Map<IngressIdentifier<?>, DataStream<?>> sourceStreams = Sources.sourceFunctionToDataStream(env, sourceFunctions);
        Map<IngressIdentifier<?>, DataStream<Message>> envelopeSources = Sources.dataStreamToEnvelopStream(universe, sourceStreams, configuration);
        return new Sources(Sources.union(envelopeSources.values()));
    }

    static Sources create(StaticallyRegisteredTypes types, Iterable<DataStream<RoutableMessage>> envelopeSources) {
        TypeInformation<Message> messageOutputType = types.registerType(Message.class);
        ArrayList messages = new ArrayList();
        Iterator<DataStream<RoutableMessage>> iterator = envelopeSources.iterator();
        while (iterator.hasNext()) {
            DataStream<RoutableMessage> input;
            DataStream<RoutableMessage> casted = input = iterator.next();
            casted.getTransformation().setOutputType(messageOutputType);
            messages.add(casted);
        }
        return new Sources(Sources.union(messages));
    }

    private static Map<IngressIdentifier<?>, DataStream<Message>> dataStreamToEnvelopStream(StatefulFunctionsUniverse universe, Map<IngressIdentifier<?>, DataStream<?>> sourceStreams, StatefulFunctionsConfig configuration) {
        RouterTranslator routerTranslator = new RouterTranslator(universe, configuration);
        return routerTranslator.translate(sourceStreams);
    }

    private static Map<IngressIdentifier<?>, DataStream<?>> sourceFunctionToDataStream(StreamExecutionEnvironment env, Map<IngressIdentifier<?>, DecoratedSource> sourceFunctions) {
        HashMap sourceStreams = new HashMap();
        sourceFunctions.forEach((id, sourceFunction) -> {
            DataStreamSource stream = env.addSource(sourceFunction.source);
            stream.name(sourceFunction.name);
            stream.uid(sourceFunction.uid);
            Sources.eraseTypeInformation(stream.getTransformation());
            sourceStreams.put((IngressIdentifier<?>)id, (DataStream<?>)stream);
        });
        return sourceStreams;
    }

    private static void eraseTypeInformation(Transformation<?> transformation) {
        transformation.setOutputType((TypeInformation)new UnimplementedTypeInfo());
    }

    private static Map<IngressIdentifier<?>, DecoratedSource> ingressToSourceFunction(StatefulFunctionsUniverse universe) {
        IngressToSourceFunctionTranslator translator = new IngressToSourceFunctionTranslator(universe);
        return translator.translate();
    }

    DataStream<Message> unionStream() {
        return this.sourceUnion;
    }

    private static <T> DataStream<T> union(Collection<DataStream<T>> sources) {
        if (sources.isEmpty()) {
            throw new IllegalStateException("There are no routers defined.");
        }
        int sourceCount = sources.size();
        Iterator<DataStream<T>> iterator = sources.iterator();
        if (sourceCount == 1) {
            return iterator.next();
        }
        DataStream<T> first = iterator.next();
        DataStream[] rest = new DataStream[sourceCount - 1];
        for (int i = 0; i < sourceCount - 1; ++i) {
            rest[i] = iterator.next();
        }
        return first.union(rest);
    }
}

