/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.window;

import org.apache.flink.ml.common.window.Windows;
import org.apache.flink.util.Preconditions;

public class CountTumblingWindows
implements Windows {
    private final long size;

    private CountTumblingWindows(long size) {
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"The size of a count window must be a positive value");
        this.size = size;
    }

    public static CountTumblingWindows of(long size) {
        return new CountTumblingWindows(size);
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        return Long.hashCode(this.size);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CountTumblingWindows)) {
            return false;
        }
        CountTumblingWindows windows = (CountTumblingWindows)obj;
        return this.size == windows.size;
    }
}

