/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.flink.statefun.extensions.ExtensionModule;
import org.apache.flink.statefun.flink.common.SetContextClassLoader;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.jsonmodule.JsonServiceLoader;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.io.spi.FlinkIoModule;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

public final class Modules {
    private final List<ExtensionModule> extensionModules;
    private final List<FlinkIoModule> ioModules;
    private final List<StatefulFunctionModule> statefulFunctionModules;
    private final StatefulFunctionsConfig configuration;

    private Modules(StatefulFunctionsConfig configuration, List<FlinkIoModule> ioModules, List<StatefulFunctionModule> statefulFunctionModules, List<ExtensionModule> extensionModules) {
        this.configuration = Objects.requireNonNull(configuration);
        this.extensionModules = extensionModules;
        this.ioModules = ioModules;
        this.statefulFunctionModules = statefulFunctionModules;
    }

    public static Modules loadFromClassPath(StatefulFunctionsConfig configuration) {
        ArrayList<StatefulFunctionModule> statefulFunctionModules = new ArrayList<StatefulFunctionModule>();
        ArrayList<FlinkIoModule> ioModules = new ArrayList<FlinkIoModule>();
        ArrayList<ExtensionModule> extensionModules = new ArrayList<ExtensionModule>();
        for (ExtensionModule extensionModule : ServiceLoader.load(ExtensionModule.class)) {
            extensionModules.add(extensionModule);
        }
        for (StatefulFunctionModule provider : ServiceLoader.load(StatefulFunctionModule.class)) {
            statefulFunctionModules.add(provider);
        }
        String remoteModuleName = configuration.getRemoteModuleName();
        for (StatefulFunctionModule statefulFunctionModule : JsonServiceLoader.load(remoteModuleName)) {
            statefulFunctionModules.add(statefulFunctionModule);
        }
        for (FlinkIoModule flinkIoModule : ServiceLoader.load(FlinkIoModule.class)) {
            ioModules.add(flinkIoModule);
        }
        return new Modules(configuration, ioModules, statefulFunctionModules, extensionModules);
    }

    public StatefulFunctionsUniverse createStatefulFunctionsUniverse() {
        Throwable throwable;
        SetContextClassLoader ignored;
        MessageFactoryKey factoryKey = this.configuration.getFactoryKey();
        StatefulFunctionsUniverse universe = new StatefulFunctionsUniverse(factoryKey);
        Map<String, String> globalConfiguration = this.configuration.getGlobalConfigurations();
        for (ExtensionModule extensionModule : this.extensionModules) {
            ignored = new SetContextClassLoader((Object)extensionModule);
            throwable = null;
            try {
                extensionModule.configure(globalConfiguration, (ExtensionModule.Binder)universe);
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        for (FlinkIoModule flinkIoModule : this.ioModules) {
            ignored = new SetContextClassLoader((Object)flinkIoModule);
            throwable = null;
            try {
                flinkIoModule.configure(globalConfiguration, (FlinkIoModule.Binder)universe);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        for (StatefulFunctionModule statefulFunctionModule : this.statefulFunctionModules) {
            ignored = new SetContextClassLoader((Object)statefulFunctionModule);
            throwable = null;
            try {
                statefulFunctionModule.configure(globalConfiguration, (StatefulFunctionModule.Binder)universe);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return universe;
    }
}

