/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.MultiJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.StreamingMultiJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;

public class StreamingMultiJoinOperatorFactory
extends AbstractStreamOperatorFactory<RowData>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<InternalTypeInfo<RowData>> inputTypeInfos;
    private final List<JoinInputSideSpec> inputSideSpecs;
    private final List<FlinkJoinType> joinTypes;
    private final MultiJoinCondition multiJoinCondition;
    private final long[] stateRetentionTime;
    private final GeneratedJoinCondition[] joinConditions;
    private final JoinKeyExtractor keyExtractor;
    private final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap;

    public StreamingMultiJoinOperatorFactory(List<InternalTypeInfo<RowData>> inputTypeInfos, List<JoinInputSideSpec> inputSideSpecs, List<FlinkJoinType> joinTypes, @Nullable MultiJoinCondition multiJoinCondition, long[] stateRetentionTime, GeneratedJoinCondition[] joinConditions, JoinKeyExtractor keyExtractor, Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap) {
        this.inputTypeInfos = inputTypeInfos;
        this.inputSideSpecs = inputSideSpecs;
        this.joinTypes = joinTypes;
        this.multiJoinCondition = multiJoinCondition;
        this.stateRetentionTime = stateRetentionTime;
        this.joinConditions = joinConditions;
        this.keyExtractor = keyExtractor;
        this.joinAttributeMap = joinAttributeMap;
    }

    public <T extends StreamOperator<RowData>> T createStreamOperator(StreamOperatorParameters<RowData> parameters) {
        StreamingMultiJoinOperator operator;
        List<RowType> inputRowTypes = this.inputTypeInfos.stream().map(InternalTypeInfo::toRowType).collect(Collectors.toList());
        StreamingMultiJoinOperator castedOperator = operator = new StreamingMultiJoinOperator(parameters, inputRowTypes, this.inputSideSpecs, this.joinTypes, this.multiJoinCondition, this.stateRetentionTime, this.joinConditions, this.keyExtractor, this.joinAttributeMap);
        return (T)((Object)castedOperator);
    }

    public Class<? extends StreamOperator<RowData>> getStreamOperatorClass(ClassLoader classLoader) {
        return StreamingMultiJoinOperator.class;
    }
}

