/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.Objects;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.Epoch;

public class AecRecord<IN, OUT> {
    private StreamRecord<IN> record;
    private Epoch<OUT> epoch;
    private int inputIndex;

    public AecRecord() {
        this.record = null;
        this.epoch = null;
        this.inputIndex = -1;
    }

    public AecRecord(StreamRecord<IN> record, Epoch<OUT> epoch, int inputIndex) {
        this.record = record;
        this.epoch = epoch;
        this.inputIndex = inputIndex;
    }

    public AecRecord<IN, OUT> reset(StreamRecord<IN> record, Epoch<OUT> epoch, int inputIndex) {
        this.record = record;
        this.epoch = epoch;
        this.inputIndex = inputIndex;
        return this;
    }

    public AecRecord<IN, OUT> setRecord(StreamRecord<IN> record) {
        this.record = record;
        return this;
    }

    public AecRecord<IN, OUT> setEpoch(Epoch<OUT> epoch) {
        this.epoch = epoch;
        return this;
    }

    public StreamRecord<IN> getRecord() {
        return this.record;
    }

    public Epoch<OUT> getEpoch() {
        return this.epoch;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public String toString() {
        return "AecRecord{record=" + String.valueOf(this.record) + ", epoch=" + String.valueOf(this.epoch) + ", inputIndex=" + this.inputIndex + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AecRecord aecRecord = (AecRecord)o;
        return this.inputIndex == aecRecord.inputIndex && Objects.equals(this.record, aecRecord.record) && Objects.equals(this.epoch, aecRecord.epoch);
    }

    public int hashCode() {
        return Objects.hash(this.record, this.epoch, this.inputIndex);
    }
}

