/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MetastoreCommitPolicy
implements PartitionCommitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreCommitPolicy.class);
    private TableMetaStoreFactory.TableMetaStore metaStore;

    public void setMetastore(TableMetaStoreFactory.TableMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    @Override
    public void commit(PartitionCommitPolicy.Context context) throws Exception {
        LinkedHashMap<String, String> partitionSpec = context.partitionSpec();
        this.metaStore.getPartition(partitionSpec).ifPresent(path -> LOG.warn("The partition {} has existed before current commit, the path is {}, this partition will be altered instead of being created", (Object)partitionSpec, path));
        this.metaStore.createOrAlterPartition(partitionSpec, context.partitionPath());
        LOG.info("Committed partition {} to metastore", partitionSpec);
    }
}

