/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.NFAStateSerializerSnapshot;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

public class NFAStateSerializer
extends TypeSerializerSingleton<NFAState> {
    private static final long serialVersionUID = 2098282423980597010L;
    private TypeSerializer<DeweyNumber> versionSerializer;
    private TypeSerializer<NodeId> nodeIdSerializer;
    private TypeSerializer<EventId> eventIdSerializer;
    private final boolean supportsPreviousTimestamp;

    public NFAStateSerializer() {
        this((TypeSerializer<DeweyNumber>)DeweyNumber.DeweyNumberSerializer.INSTANCE, (TypeSerializer<NodeId>)new NodeId.NodeIdSerializer(), (TypeSerializer<EventId>)EventId.EventIdSerializer.INSTANCE, true);
    }

    NFAStateSerializer(TypeSerializer<DeweyNumber> versionSerializer, TypeSerializer<NodeId> nodeIdSerializer, TypeSerializer<EventId> eventIdSerializer, boolean supportsPreviousTimestamp) {
        this.versionSerializer = (TypeSerializer)Preconditions.checkNotNull(versionSerializer);
        this.nodeIdSerializer = (TypeSerializer)Preconditions.checkNotNull(nodeIdSerializer);
        this.eventIdSerializer = (TypeSerializer)Preconditions.checkNotNull(eventIdSerializer);
        this.supportsPreviousTimestamp = supportsPreviousTimestamp;
    }

    public boolean isSupportsPreviousTimestamp() {
        return this.supportsPreviousTimestamp;
    }

    public boolean isImmutableType() {
        return false;
    }

    public NFAState createInstance() {
        return null;
    }

    public NFAState copy(NFAState from) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.serialize(from, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)baos));
            baos.close();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            NFAState copy = this.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)bais));
            bais.close();
            return copy;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy NFA.", e);
        }
    }

    public NFAState copy(NFAState from, NFAState reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(NFAState record, DataOutputView target) throws IOException {
        this.serializeComputationStates(record.getPartialMatches(), target);
        this.serializeComputationStates(record.getCompletedMatches(), target);
    }

    public NFAState deserialize(DataInputView source) throws IOException {
        PriorityQueue<ComputationState> partialMatches = this.deserializeComputationStates(source);
        PriorityQueue<ComputationState> completedMatches = this.deserializeComputationStates(source);
        return new NFAState(partialMatches, completedMatches);
    }

    public NFAState deserialize(NFAState reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.copyStates(source, target);
        this.copyStates(source, target);
    }

    private void copyStates(DataInputView source, DataOutputView target) throws IOException {
        int computationStateNo = source.readInt();
        target.writeInt(computationStateNo);
        for (int i = 0; i < computationStateNo; ++i) {
            this.copySingleComputationState(source, target);
        }
    }

    public TypeSerializerSnapshot<NFAState> snapshotConfiguration() {
        return new NFAStateSerializerSnapshot(this);
    }

    TypeSerializer<DeweyNumber> getVersionSerializer() {
        return this.versionSerializer;
    }

    TypeSerializer<NodeId> getNodeIdSerializer() {
        return this.nodeIdSerializer;
    }

    TypeSerializer<EventId> getEventIdSerializer() {
        return this.eventIdSerializer;
    }

    private void serializeComputationStates(Queue<ComputationState> states, DataOutputView target) throws IOException {
        target.writeInt(states.size());
        for (ComputationState computationState : states) {
            this.serializeSingleComputationState(computationState, target);
        }
    }

    private PriorityQueue<ComputationState> deserializeComputationStates(DataInputView source) throws IOException {
        PriorityQueue<ComputationState> computationStates = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        int computationStateNo = source.readInt();
        for (int i = 0; i < computationStateNo; ++i) {
            ComputationState computationState = this.deserializeSingleComputationState(source);
            computationStates.add(computationState);
        }
        return computationStates;
    }

    private void serializeSingleComputationState(ComputationState computationState, DataOutputView target) throws IOException {
        StringValue.writeString((CharSequence)computationState.getCurrentStateName(), (DataOutput)target);
        this.nodeIdSerializer.serialize((Object)computationState.getPreviousBufferEntry(), target);
        this.versionSerializer.serialize((Object)computationState.getVersion(), target);
        target.writeLong(computationState.getStartTimestamp());
        if (this.supportsPreviousTimestamp) {
            target.writeLong(computationState.getPreviousTimestamp());
        }
        this.serializeStartEvent(computationState.getStartEventID(), target);
    }

    private ComputationState deserializeSingleComputationState(DataInputView source) throws IOException {
        String stateName = StringValue.readString((DataInput)source);
        NodeId prevState = (NodeId)this.nodeIdSerializer.deserialize(source);
        DeweyNumber version = (DeweyNumber)this.versionSerializer.deserialize(source);
        long startTimestamp = source.readLong();
        long previousTimestamp = -1L;
        if (this.supportsPreviousTimestamp) {
            previousTimestamp = source.readLong();
        }
        EventId startEventId = this.deserializeStartEvent(source);
        return ComputationState.createState(stateName, prevState, version, startTimestamp, previousTimestamp, startEventId);
    }

    private void copySingleComputationState(DataInputView source, DataOutputView target) throws IOException {
        StringValue.copyString((DataInput)source, (DataOutput)target);
        NodeId prevState = (NodeId)this.nodeIdSerializer.deserialize(source);
        this.nodeIdSerializer.serialize((Object)prevState, target);
        DeweyNumber version = (DeweyNumber)this.versionSerializer.deserialize(source);
        this.versionSerializer.serialize((Object)version, target);
        long startTimestamp = source.readLong();
        target.writeLong(startTimestamp);
        if (this.supportsPreviousTimestamp) {
            long previousTimestamp = source.readLong();
            target.writeLong(previousTimestamp);
        }
        this.copyStartEvent(source, target);
    }

    private void serializeStartEvent(EventId startEventID, DataOutputView target) throws IOException {
        if (startEventID != null) {
            target.writeByte(1);
            this.eventIdSerializer.serialize((Object)startEventID, target);
        } else {
            target.writeByte(0);
        }
    }

    private EventId deserializeStartEvent(DataInputView source) throws IOException {
        byte isNull = source.readByte();
        EventId startEventId = null;
        if (isNull == 1) {
            startEventId = (EventId)this.eventIdSerializer.deserialize(source);
        }
        return startEventId;
    }

    private void copyStartEvent(DataInputView source, DataOutputView target) throws IOException {
        byte isNull = source.readByte();
        target.writeByte((int)isNull);
        if (isNull == 1) {
            EventId startEventId = (EventId)this.eventIdSerializer.deserialize(source);
            this.eventIdSerializer.serialize((Object)startEventId, target);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.versionSerializer == null || this.nodeIdSerializer == null || this.eventIdSerializer == null) {
            this.versionSerializer = DeweyNumber.DeweyNumberSerializer.INSTANCE;
            this.eventIdSerializer = EventId.EventIdSerializer.INSTANCE;
            this.nodeIdSerializer = new NodeId.NodeIdSerializer();
        }
    }
}

