/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.AdaptiveJoinExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecAdaptiveJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.TableConfigUtils;

public class AdaptiveJoinProcessor
implements ExecNodeGraphProcessor {
    @Override
    public ExecNodeGraph process(ExecNodeGraph execGraph, ProcessorContext context) {
        if (execGraph.getRootNodes().get(0) instanceof StreamExecNode) {
            throw new TableException("AdaptiveJoin does not support streaming jobs.");
        }
        if (!this.isAdaptiveJoinEnabled(context)) {
            return execGraph;
        }
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                this.visitInputs(node);
                if (AdaptiveJoinProcessor.this.shouldStrictKeepInputAsIs(node.getInputProperties())) {
                    return;
                }
                for (int i = 0; i < node.getInputEdges().size(); ++i) {
                    ExecEdge edge = node.getInputEdges().get(i);
                    ExecNode<?> newNode = AdaptiveJoinProcessor.this.tryReplaceWithAdaptiveJoinNode(edge.getSource());
                    node.replaceInputEdge(i, ExecEdge.builder().source(newNode).target(node).shuffle(edge.getShuffle()).exchangeMode(edge.getExchangeMode()).build());
                }
            }
        };
        List<ExecNode<?>> newRootNodes = execGraph.getRootNodes().stream().map(node -> {
            node = this.tryReplaceWithAdaptiveJoinNode((ExecNode<?>)node);
            node.accept(visitor);
            return node;
        }).collect(Collectors.toList());
        return new ExecNodeGraph(execGraph.getFlinkVersion(), newRootNodes);
    }

    private ExecNode<?> tryReplaceWithAdaptiveJoinNode(ExecNode<?> node) {
        if (!this.areAllInputsHashShuffle(node) || this.shouldKeepUpstreamExchangeInputAsIs(node.getInputEdges())) {
            return node;
        }
        BatchExecAdaptiveJoin newNode = node;
        if (node instanceof AdaptiveJoinExecNode && ((AdaptiveJoinExecNode)((Object)node)).canBeTransformedToAdaptiveJoin()) {
            BatchExecAdaptiveJoin adaptiveJoin = ((AdaptiveJoinExecNode)((Object)node)).toAdaptiveJoinNode();
            this.replaceInputEdge(adaptiveJoin, node);
            newNode = adaptiveJoin;
        }
        return newNode;
    }

    private boolean shouldStrictKeepInputAsIs(List<InputProperty> inputProperties) {
        return inputProperties.stream().anyMatch(inputProperty -> inputProperty.getRequiredDistribution().getType() == InputProperty.DistributionType.KEEP_INPUT_AS_IS && ((InputProperty.KeepInputAsIsDistribution)inputProperty.getRequiredDistribution()).isStrict());
    }

    private boolean shouldKeepInputAsIs(List<InputProperty> inputProperties) {
        return inputProperties.stream().anyMatch(inputProperty -> inputProperty.getRequiredDistribution().getType() == InputProperty.DistributionType.KEEP_INPUT_AS_IS);
    }

    private boolean shouldKeepUpstreamExchangeInputAsIs(List<ExecEdge> inputEdges) {
        return inputEdges.stream().filter(execEdge -> execEdge.getSource() instanceof BatchExecExchange).map(execEdge -> (BatchExecExchange)execEdge.getSource()).anyMatch(exchange -> this.shouldKeepInputAsIs(exchange.getInputProperties()));
    }

    private boolean isAdaptiveJoinEnabled(ProcessorContext context) {
        TableConfig tableConfig = context.getPlanner().getTableConfig();
        boolean isAdaptiveJoinEnabled = tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY) != OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.NONE && !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.BroadcastHashJoin);
        JobManagerOptions.SchedulerType schedulerType = context.getPlanner().getExecEnv().getConfig().getSchedulerType().orElse(JobManagerOptions.SchedulerType.AdaptiveBatch);
        boolean isAdaptiveBatchSchedulerEnabled = schedulerType == JobManagerOptions.SchedulerType.AdaptiveBatch;
        boolean isJobRecoveryEnabled = (Boolean)tableConfig.get(BatchExecutionOptions.JOB_RECOVERY_ENABLED);
        return (isAdaptiveJoinEnabled |= tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY) != OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.NONE) && isAdaptiveBatchSchedulerEnabled && !isJobRecoveryEnabled;
    }

    private boolean areAllInputsHashShuffle(ExecNode<?> node) {
        for (InputProperty inputProperty : node.getInputProperties()) {
            if (inputProperty.getRequiredDistribution().getType() == InputProperty.DistributionType.HASH) continue;
            return false;
        }
        return true;
    }

    private void replaceInputEdge(ExecNode<?> newNode, ExecNode<?> originalNode) {
        ArrayList<ExecEdge> inputEdges = new ArrayList<ExecEdge>();
        for (int i = 0; i < originalNode.getInputEdges().size(); ++i) {
            ExecEdge edge = originalNode.getInputEdges().get(i);
            inputEdges.add(ExecEdge.builder().source(edge.getSource()).target(newNode).shuffle(edge.getShuffle()).exchangeMode(edge.getExchangeMode()).build());
        }
        newNode.setInputEdges(inputEdges);
    }
}

