/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.utils.TypeConversions;
import scala.Option;

public class SqlAggFunctionVisitor
extends ExpressionDefaultVisitor<SqlAggFunction> {
    private static final Map<FunctionDefinition, SqlAggFunction> AGG_DEF_SQL_OPERATOR_MAPPING = new IdentityHashMap<FunctionDefinition, SqlAggFunction>();
    private final RelBuilder relBuilder;

    public SqlAggFunctionVisitor(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
    }

    public SqlAggFunction visit(CallExpression call) {
        FunctionDefinition definition;
        if (!ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.AGGREGATE) && !ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.TABLE_AGGREGATE)) {
            this.defaultMethod((Expression)call);
        }
        if (AGG_DEF_SQL_OPERATOR_MAPPING.containsKey(definition = call.getFunctionDefinition())) {
            return AGG_DEF_SQL_OPERATOR_MAPPING.get(definition);
        }
        if (BuiltInFunctionDefinitions.DISTINCT == definition) {
            Expression innerAgg = (Expression)call.getChildren().get(0);
            return (SqlAggFunction)innerAgg.accept((ExpressionVisitor)this);
        }
        return this.createSqlAggFunction(call);
    }

    private SqlAggFunction createSqlAggFunction(CallExpression call) {
        FunctionDefinition definition = call.getFunctionDefinition();
        if (definition instanceof AggregateFunctionDefinition) {
            return this.createLegacySqlAggregateFunction(call.getFunctionIdentifier().orElse(null), (AggregateFunctionDefinition)definition);
        }
        if (definition instanceof TableAggregateFunctionDefinition) {
            return this.createLegacySqlTableAggregateFunction(call.getFunctionIdentifier().orElse(null), (TableAggregateFunctionDefinition)definition);
        }
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(this.relBuilder).getCatalogManager().getDataTypeFactory();
        TypeInference typeInference = definition.getTypeInference(dataTypeFactory);
        return BridgingSqlAggFunction.of(dataTypeFactory, ShortcutUtils.unwrapTypeFactory(this.relBuilder), SqlKind.OTHER_FUNCTION, ContextResolvedFunction.fromCallExpression((CallExpression)call), typeInference);
    }

    private SqlAggFunction createLegacySqlAggregateFunction(@Nullable FunctionIdentifier identifier, AggregateFunctionDefinition definition) {
        AggregateFunction aggFunc = definition.getAggregateFunction();
        FunctionIdentifier adjustedIdentifier = identifier != null ? identifier : FunctionIdentifier.of((String)UserDefinedFunctionHelper.generateInlineFunctionName((UserDefinedFunction)aggFunc));
        return new AggSqlFunction(adjustedIdentifier, aggFunc.toString(), (ImperativeAggregateFunction<?, ?>)aggFunc, TypeConversions.fromLegacyInfoToDataType((TypeInformation)definition.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)definition.getAccumulatorTypeInfo()), ShortcutUtils.unwrapTypeFactory(this.relBuilder), aggFunc.getRequirements().contains(FunctionRequirement.OVER_WINDOW_ONLY), (Option<SqlReturnTypeInference>)Option.empty());
    }

    private SqlAggFunction createLegacySqlTableAggregateFunction(@Nullable FunctionIdentifier identifier, TableAggregateFunctionDefinition definition) {
        TableAggregateFunction aggFunc = definition.getTableAggregateFunction();
        FunctionIdentifier adjustedIdentifier = identifier != null ? identifier : FunctionIdentifier.of((String)UserDefinedFunctionHelper.generateInlineFunctionName((UserDefinedFunction)aggFunc));
        return new AggSqlFunction(adjustedIdentifier, aggFunc.toString(), (ImperativeAggregateFunction<?, ?>)aggFunc, TypeConversions.fromLegacyInfoToDataType((TypeInformation)definition.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)definition.getAccumulatorTypeInfo()), ShortcutUtils.unwrapTypeFactory(this.relBuilder), false, (Option<SqlReturnTypeInference>)Option.empty());
    }

    protected SqlAggFunction defaultMethod(Expression expression) {
        throw new TableException("Unexpected expression: " + expression);
    }

    static {
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.AVG, FlinkSqlOperatorTable.AVG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.COUNT, FlinkSqlOperatorTable.COUNT);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.MAX, FlinkSqlOperatorTable.MAX);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.MIN, FlinkSqlOperatorTable.MIN);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.SUM, FlinkSqlOperatorTable.SUM);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.FIRST_VALUE, FlinkSqlOperatorTable.FIRST_VALUE);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.LAST_VALUE, FlinkSqlOperatorTable.LAST_VALUE);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.LAG, FlinkSqlOperatorTable.LAG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.LEAD, FlinkSqlOperatorTable.LEAD);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.LISTAGG, FlinkSqlOperatorTable.LISTAGG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.SUM0, FlinkSqlOperatorTable.SUM0);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_POP, FlinkSqlOperatorTable.STDDEV_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_SAMP, FlinkSqlOperatorTable.STDDEV_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.VAR_POP, FlinkSqlOperatorTable.VAR_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.VAR_SAMP, FlinkSqlOperatorTable.VAR_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.COLLECT, FlinkSqlOperatorTable.COLLECT);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY_AGG, FlinkSqlOperatorTable.ARRAY_AGG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_OBJECTAGG_NULL_ON_NULL, FlinkSqlOperatorTable.JSON_OBJECTAGG_NULL_ON_NULL);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_OBJECTAGG_ABSENT_ON_NULL, FlinkSqlOperatorTable.JSON_OBJECTAGG_ABSENT_ON_NULL);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_ARRAYAGG_NULL_ON_NULL, FlinkSqlOperatorTable.JSON_ARRAYAGG_NULL_ON_NULL);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_ARRAYAGG_ABSENT_ON_NULL, FlinkSqlOperatorTable.JSON_ARRAYAGG_ABSENT_ON_NULL);
    }
}

