/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.embedding.transcoders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.flex.compiler.common.IFileSpecificationGetter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.filespecs.IBinaryFileSpecification;
import org.apache.flex.compiler.internal.embedding.EmbedAttribute;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.embedding.EmbedMIMEType;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.ClassNode;
import org.apache.flex.compiler.internal.tree.as.FileNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.ImportNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.flex.compiler.internal.tree.as.PackageNode;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.EmbedUnableToReadSourceProblem;
import org.apache.flex.compiler.problems.EmbedUnsupportedAttributeProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.swc.ISWCFileEntry;
import org.apache.flex.swf.tags.DefineBinaryDataTag;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;

public abstract class TranscoderBase {
    public static final String CORE_PACKAGE = "mx.core";
    protected static final String UTILS_PACKAGE = "mx.utils";
    protected static final String byteArrayNamePostfix = "ByteArray";
    protected final EmbedData data;
    protected final Workspace workspace;
    protected final ISWCFileEntry swcSource;
    protected String baseClassQName;
    protected String source;
    private EmbedMIMEType mimeType;

    protected TranscoderBase(EmbedData data, Workspace workspace) {
        this.data = data;
        this.workspace = workspace;
        this.swcSource = data.getSWCSource();
    }

    protected abstract Map<String, ICharacterTag> doTranscode(Collection<ITag> var1, Collection<ICompilerProblem> var2);

    public Map<String, ICharacterTag> getTags(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        return this.doTranscode(tags, problems);
    }

    public String getBaseClassQName() {
        return this.baseClassQName;
    }

    public String getBaseClassName() {
        return this.baseClassQName.substring(this.baseClassQName.lastIndexOf(".") + 1);
    }

    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = true;
        for (EmbedAttribute attribute : this.data.getAttributes()) {
            if (this.setAttribute(attribute)) continue;
            problems.add(new EmbedUnsupportedAttributeProblem(location, attribute, (EmbedMIMEType)((Object)this.data.getAttribute(EmbedAttribute.MIME_TYPE))));
            result = false;
        }
        if (!this.checkAttributeValues(location, problems)) {
            result = false;
        }
        return result;
    }

    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SOURCE: {
                this.source = (String)this.data.getAttribute(EmbedAttribute.SOURCE);
                break;
            }
            case MIME_TYPE: {
                this.mimeType = (EmbedMIMEType)((Object)this.data.getAttribute(EmbedAttribute.MIME_TYPE));
                break;
            }
            default: {
                isSupported = false;
            }
        }
        return isSupported;
    }

    protected boolean checkAttributeValues(ISourceLocation location, Collection<ICompilerProblem> problems) {
        return true;
    }

    protected DefineBinaryDataTag buildBinaryDataTag(Collection<ICompilerProblem> problems) {
        byte[] bytes = this.getDataBytes(problems);
        if (bytes == null) {
            return null;
        }
        return new DefineBinaryDataTag(bytes);
    }

    protected InputStream getDataStream(Collection<ICompilerProblem> problems) {
        InputStream inStrm = null;
        if (this.swcSource != null) {
            inStrm = this.getDataStream(this.swcSource, problems);
        } else {
            IBinaryFileSpecification fileSpec = this.workspace.getLatestBinaryFileSpecification(this.source);
            inStrm = this.getDataStream(fileSpec, problems);
        }
        return inStrm;
    }

    private InputStream getDataStream(ISWCFileEntry swcSource, Collection<ICompilerProblem> problems) {
        InputStream inStrm = null;
        try {
            inStrm = swcSource.createInputStream();
        }
        catch (IOException e) {
            problems.add(new EmbedUnableToReadSourceProblem(e, swcSource.getPath()));
        }
        return inStrm;
    }

    private InputStream getDataStream(IBinaryFileSpecification fileSpec, Collection<ICompilerProblem> problems) {
        InputStream inStrm = null;
        try {
            inStrm = fileSpec.createInputStream();
        }
        catch (IOException e) {
            problems.add(new EmbedUnableToReadSourceProblem(e, fileSpec.getPath()));
        }
        return inStrm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDataBytes(Collection<ICompilerProblem> problems) {
        InputStream inStrm = this.getDataStream(problems);
        if (inStrm == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inStrm);
        }
        catch (IOException e) {
            problems.add(new EmbedUnableToReadSourceProblem(e, this.source));
        }
        finally {
            if (inStrm != null) {
                try {
                    inStrm.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode contents = packageNode.getScopedNode();
        ImportNode importNode = ImportNode.buildImportNode(this.getBaseClassQName());
        contents.addItem(importNode);
        ClassNode classNode = new ClassNode(new IdentifierNode(this.data.getQName()));
        classNode.setBaseClass(new IdentifierNode(this.getBaseClassName()));
        classNode.setNamespace(new NamespaceIdentifierNode("public"));
        contents.addItem(classNode);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }

    public byte[] buildABC(ICompilerProject project, Collection<ICompilerProblem> problems) {
        assert (false) : "unimplemented buildABC called";
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranscoderBase)) {
            return false;
        }
        TranscoderBase t = (TranscoderBase)o;
        if (!this.source.equals(t.source) || !this.baseClassQName.equals(t.baseClassQName) || this.mimeType != t.mimeType) {
            return false;
        }
        if (this.swcSource == null && t.swcSource != null || this.swcSource != null && t.swcSource == null) {
            return false;
        }
        return this.swcSource == null || this.swcSource.getContainingSWCPath().equals(t.swcSource.getContainingSWCPath()) && this.swcSource.getPath().equals(t.swcSource.getPath());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.source.hashCode();
        hashCode ^= this.baseClassQName.hashCode();
        hashCode ^= this.mimeType.toString().hashCode();
        if (this.swcSource != null) {
            hashCode ^= this.swcSource.getContainingSWCPath().hashCode();
            hashCode ^= this.swcSource.getPath().hashCode();
        }
        return hashCode;
    }
}

