/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuntimeSharedLibraryPathInfo {
    public static final String SIGNED_RSL_URL_EXTENSION = "swz";
    public static final String SIGNED_RSL_URL_DOT_EXTENSION = ".swz";
    private String swcPath;
    private File swcVf;
    private List<String> rslURLs = new ArrayList<String>();
    private List<String> policyFileURLs;
    private List<Boolean> isSignedList;

    public boolean isRSLURLSigned(String url) {
        if (url == null) {
            return false;
        }
        return url.endsWith(SIGNED_RSL_URL_DOT_EXTENSION);
    }

    public void setSWCPath(String swcPath) {
        this.swcPath = swcPath;
    }

    public String getSWCPath() {
        return this.swcPath;
    }

    public void setSWCFile(File vf) {
        this.swcVf = vf;
    }

    public File getSWCFile() {
        return this.swcVf;
    }

    public void addRSLURL(String url) {
        if (url == null) {
            throw new NullPointerException("url may not be null");
        }
        this.rslURLs.add(url);
        this.addSignedFlag(this.isRSLURLSigned(url));
    }

    public List<String> getRSLURLs() {
        return this.rslURLs;
    }

    public void addPolicyFileURL(String url) {
        if (this.policyFileURLs == null) {
            this.policyFileURLs = new ArrayList<String>();
        }
        this.policyFileURLs.add(url == null ? "" : url);
    }

    public List<String> getPolicyFileURLs() {
        return this.policyFileURLs == null ? Collections.emptyList() : this.policyFileURLs;
    }

    public List<Boolean> getSignedFlags() {
        return this.isSignedList;
    }

    private void addSignedFlag(boolean isSigned) {
        if (this.isSignedList == null) {
            this.isSignedList = new ArrayList<Boolean>();
        }
        this.isSignedList.add(isSigned);
    }
}

