/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.parsing.ISourceFragment;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLClassNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFactoryNode;

class MXMLFactoryNode
extends MXMLInstanceNode
implements IMXMLFactoryNode {
    private MXMLClassNode classNode;

    MXMLFactoryNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLFactoryID;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.classNode : null;
    }

    @Override
    public int getChildCount() {
        return this.classNode != null ? 1 : 0;
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        this.initialize(builder);
        super.initializeFromTag(builder, tag);
    }

    protected void initializeFromFragments(MXMLTreeBuilder builder, ISourceLocation location, ISourceFragment[] fragments) {
        this.initialize(builder);
        this.setLocation(location);
        this.classNode = new MXMLClassNode(this);
        this.classNode.initializeFromFragments(builder, location, fragments);
    }

    private void initialize(MXMLTreeBuilder builder) {
        FlexProject project = builder.getProject();
        String qname = project.getClassFactoryClass();
        this.setClassReference(project, qname);
        builder.addExpressionDependency(qname);
    }

    @Override
    public IMXMLClassNode getClassNode() {
        return this.classNode;
    }
}

