/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.flex.compiler.internal.codegen.databinding.BindingAnalyzer;
import org.apache.flex.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.flex.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.WatcherAnalyzer;
import org.apache.flex.compiler.internal.codegen.databinding.WatcherInfoBase;
import org.apache.flex.compiler.internal.codegen.databinding.XMLWatcherInfo;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDataBindingNode;

public class BindingDatabase {
    private Set<BindingInfo> bindingInfoSet = new TreeSet<BindingInfo>();
    private Map<Integer, Integer> twoWayPairs = null;
    private WatcherInfoBase watcherList = new WatcherInfoBase(null, null, new ArrayList<String>());
    private int numWatchers = -1;
    private ASScope scope;
    private boolean analysisFinished = false;
    private static List<BindingDatabase> _diagnosticLogger;
    public static WeakHashMap<IClassDefinition, BindingDatabase> bindingMap;
    public int _watchersCreated;

    public BindingDatabase() {
        if (_diagnosticLogger != null) {
            _diagnosticLogger.add(this);
        }
    }

    public static void _setDiagnosticLogger(List<BindingDatabase> logger) {
        assert (_diagnosticLogger == null || logger == null);
        _diagnosticLogger = logger;
    }

    public BindingInfo analyze(IMXMLDataBindingNode node, Collection<ICompilerProblem> problems, MXMLClassDirectiveProcessor host) {
        BindingInfo bindingInfo = BindingAnalyzer.analyze(node, this, problems, this.bindingInfoSet.size(), host);
        this.bindingInfoSet.add(bindingInfo);
        WatcherAnalyzer watcherAnalyzer = new WatcherAnalyzer(this, problems, bindingInfo, host.getProject());
        watcherAnalyzer.analyze();
        return bindingInfo;
    }

    public void analyzeBindingNode(IMXMLBindingNode node, Collection<ICompilerProblem> problems, MXMLClassDirectiveProcessor host) {
        BindingInfo info1 = this.analyzeBindingNode(node, problems, host, false);
        if (node.getTwoWay()) {
            BindingInfo info2 = this.analyzeBindingNode(node, problems, host, true);
            info1.setTwoWayCounterpart(info2.getIndex());
            info2.setTwoWayCounterpart(info1.getIndex());
        }
    }

    private BindingInfo analyzeBindingNode(IMXMLBindingNode node, Collection<ICompilerProblem> problems, MXMLClassDirectiveProcessor host, boolean reverseSourceAndDest) {
        BindingInfo bindingInfo = BindingAnalyzer.analyze(node, this, problems, this.bindingInfoSet.size(), reverseSourceAndDest, host);
        this.bindingInfoSet.add(bindingInfo);
        WatcherAnalyzer watcherAnalyzer = new WatcherAnalyzer(this, problems, bindingInfo, host.getProject());
        watcherAnalyzer.analyze();
        return bindingInfo;
    }

    public void finishAnalysis() {
        assert (!this.analysisFinished);
        this.assignWatchersToSlots();
        this.makeTwoWayMap();
        this.analysisFinished = true;
        assert (this.isValid());
    }

    public Set<BindingInfo> getBindingInfo() {
        return this.bindingInfoSet;
    }

    public Map<Integer, Integer> getTwoWayBindingInfoPairs() {
        assert (this.twoWayPairs != null);
        return this.twoWayPairs;
    }

    public Set<Map.Entry<Object, WatcherInfoBase>> getWatcherChains() {
        assert (this.analysisFinished);
        return this.watcherList.getChildren();
    }

    public int getNumWatchers() {
        assert (this.analysisFinished);
        return this.numWatchers;
    }

    public boolean getRequiresPropertyGetter() {
        assert (this.analysisFinished);
        boolean ret = false;
        Set<Map.Entry<Object, WatcherInfoBase>> rootWatchers = this.getWatcherChains();
        if (rootWatchers == null) {
            return false;
        }
        for (Map.Entry<Object, WatcherInfoBase> rootWatcherEntry : rootWatchers) {
            WatcherInfoBase rootWatcher = rootWatcherEntry.getValue();
            if (rootWatcher.type != WatcherInfoBase.WatcherType.PROPERTY) continue;
            ret = true;
        }
        return ret;
    }

    public ASScope getScope() {
        return this.scope;
    }

    public void setScope(ASScope scope) {
        assert (this.scope == null || this.scope == scope);
        this.scope = scope;
    }

    public WatcherInfoBase getOrCreateWatcher(WatcherInfoBase parent, WatcherInfoBase.WatcherType type, Object watcherKey, Collection<ICompilerProblem> problems, IASNode sourceNode, List<String> eventNames) {
        assert (watcherKey != null);
        WatcherInfoBase ret = null;
        WatcherInfoBase newParent = parent != null ? parent : this.watcherList;
        WatcherInfoBase existingChild = newParent.getOrCreateChildren().get(watcherKey);
        if (existingChild != null) {
            ret = existingChild;
        } else {
            switch (type) {
                case PROPERTY: {
                    ret = new PropertyWatcherInfo(problems, sourceNode, eventNames);
                    break;
                }
                case STATIC_PROPERTY: {
                    ret = new StaticPropertyWatcherInfo(problems, sourceNode, eventNames);
                    break;
                }
                case FUNCTION: {
                    ret = new FunctionWatcherInfo(problems, sourceNode, eventNames);
                    break;
                }
                case XML: {
                    ret = new XMLWatcherInfo(problems, sourceNode, eventNames);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ret.isRoot = parent == null;
            newParent.children.put(watcherKey, ret);
        }
        assert (this.objIsType(ret, type));
        return ret;
    }

    private boolean objIsType(WatcherInfoBase obj, WatcherInfoBase.WatcherType type) {
        boolean ret = false;
        switch (type) {
            case PROPERTY: {
                ret = obj instanceof PropertyWatcherInfo;
                break;
            }
            case STATIC_PROPERTY: {
                ret = obj instanceof StaticPropertyWatcherInfo;
                break;
            }
            case FUNCTION: {
                ret = obj instanceof FunctionWatcherInfo;
                break;
            }
            case XML: {
                ret = obj instanceof XMLWatcherInfo;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.bindingInfoSet.isEmpty()) {
            sb.append("<no binding info");
        } else {
            sb.append("bindingInfo:\n");
            boolean first = true;
            for (BindingInfo info : this.bindingInfoSet) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append("   " + info);
                first = false;
            }
        }
        if (this.watcherList.getChildren() != null) {
            sb.append("\nwatcher chains: ");
            for (Map.Entry<Object, WatcherInfoBase> ent : this.watcherList.getChildren()) {
                sb.append("\n" + ent.getValue().dump("   "));
            }
        } else {
            sb.append("\n<no watcher chains>");
        }
        return sb.toString();
    }

    private void assignWatchersToSlots() {
        int curIndex = -1;
        this.numWatchers = curIndex = this.watcherList.assignIndex(curIndex);
    }

    private void makeTwoWayMap() {
        assert (this.twoWayPairs == null);
        this.twoWayPairs = new LinkedHashMap<Integer, Integer>();
        for (BindingInfo bindingInfo : this.getBindingInfo()) {
            if (bindingInfo.getTwoWayCounterpart() < 0 || this.twoWayPairs.get(bindingInfo.getIndex()) != null || this.twoWayPairs.get(bindingInfo.getTwoWayCounterpart()) != null) continue;
            this.twoWayPairs.put(bindingInfo.getIndex(), bindingInfo.getTwoWayCounterpart());
        }
    }

    private boolean isValid() {
        int i = 0;
        for (BindingInfo info : this.bindingInfoSet) {
            if (info.getIndex() != i) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        bindingMap = new WeakHashMap();
    }
}

