package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetBusinessJobConfigResponse;
import org.apache.fineract.client.models.GetBusinessStepConfigResponse;
import org.apache.fineract.client.models.UpdateBusinessStepConfigRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface BusinessStepConfigurationApi {
    /**
    * List Business Step Configurations for a Job
    * Returns the available Business Steps for a job
        * @param jobName jobName (required)
    * @return Call&lt;GetBusinessStepConfigResponse&gt;
    */
    @GET("v1/jobs/{jobName}/available-steps")
    Call<GetBusinessStepConfigResponse> retrieveAllAvailableBusinessStep(@retrofit2.http.Path("jobName") String jobName);

    /**
    * List Business Jobs
    * Returns the configured Business Jobs
    * @return Call&lt;GetBusinessJobConfigResponse&gt;
    */
    @GET("v1/jobs/names")
    Call<GetBusinessJobConfigResponse> retrieveAllConfiguredBusinessJobs();

    /**
    * List Business Step Configurations for a Job
    * Returns the configured Business Steps for a job
        * @param jobName jobName (required)
    * @return Call&lt;GetBusinessStepConfigResponse&gt;
    */
    @GET("v1/jobs/{jobName}/steps")
    Call<GetBusinessStepConfigResponse> retrieveAllConfiguredBusinessStep(@retrofit2.http.Path("jobName") String jobName);

    /**
    * List Business Step Configurations for a Job
    * Updates the Business steps execution order for a job
        * @param jobName jobName (required)
        * @param updateBusinessStepConfigRequest  (optional)
    * @return Call&lt;Void&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/jobs/{jobName}/steps")
    Call<Void> updateJobBusinessStepConfig(@retrofit2.http.Path("jobName") String jobName, @retrofit2.http.Body UpdateBusinessStepConfigRequest updateBusinessStepConfigRequest);


        /**
        * List Business Step Configurations for a Job
        * Updates the Business steps execution order for a job
            * @param jobName jobName (required)
            * @param updateBusinessStepConfigRequest  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/jobs/{jobName}/steps")
    Call<Void> updateJobBusinessStepConfig(@retrofit2.http.Path("jobName") String jobName);

        /**
        * List Business Step Configurations for a Job
        * Returns the available Business Steps for a job
            * @param jobName jobName (required)
        * @return Call&lt;GetBusinessStepConfigResponse&gt;
        */
    @GET("v1/jobs/{jobName}/available-steps")
    Call<GetBusinessStepConfigResponse> retrieveAllAvailableBusinessStep(@retrofit2.http.Path("jobName") String jobName, @HeaderMap Map<String, String> headers);

        /**
        * List Business Jobs
        * Returns the configured Business Jobs
        * @return Call&lt;GetBusinessJobConfigResponse&gt;
        */
    @GET("v1/jobs/names")
    Call<GetBusinessJobConfigResponse> retrieveAllConfiguredBusinessJobs(@HeaderMap Map<String, String> headers);

        /**
        * List Business Step Configurations for a Job
        * Returns the configured Business Steps for a job
            * @param jobName jobName (required)
        * @return Call&lt;GetBusinessStepConfigResponse&gt;
        */
    @GET("v1/jobs/{jobName}/steps")
    Call<GetBusinessStepConfigResponse> retrieveAllConfiguredBusinessStep(@retrofit2.http.Path("jobName") String jobName, @HeaderMap Map<String, String> headers);

        /**
        * List Business Step Configurations for a Job
        * Updates the Business steps execution order for a job
            * @param jobName jobName (required)
            * @param updateBusinessStepConfigRequest  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/jobs/{jobName}/steps")
    Call<Void> updateJobBusinessStepConfig(@retrofit2.http.Path("jobName") String jobName, @retrofit2.http.Body UpdateBusinessStepConfigRequest updateBusinessStepConfigRequest, @HeaderMap Map<String, String> headers);


        /**
        * List Business Step Configurations for a Job
        * Updates the Business steps execution order for a job
            * @param jobName jobName (required)
            * @param updateBusinessStepConfigRequest  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/jobs/{jobName}/steps")
    Call<Void> updateJobBusinessStepConfig(@retrofit2.http.Path("jobName") String jobName, @HeaderMap Map<String, String> headers);
}
