/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;

/**
 * LoanAccountLock
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanAccountLock {
  public static final String SERIALIZED_NAME_ERROR = "error";
  @SerializedName(SERIALIZED_NAME_ERROR)
  private String error;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  /**
   * Gets or Sets lockOwner
   */
  @JsonAdapter(LockOwnerEnum.Adapter.class)
  public enum LockOwnerEnum {
    COB_CHUNK_PROCESSING("LOAN_COB_CHUNK_PROCESSING"),
    
    INLINE_COB_PROCESSING("LOAN_INLINE_COB_PROCESSING");

    private String value;

    LockOwnerEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LockOwnerEnum fromValue(String value) {
      for (LockOwnerEnum b : LockOwnerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LockOwnerEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LockOwnerEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LockOwnerEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LockOwnerEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LOCK_OWNER = "lockOwner";
  @SerializedName(SERIALIZED_NAME_LOCK_OWNER)
  private LockOwnerEnum lockOwner;

  public static final String SERIALIZED_NAME_LOCK_PLACED_ON = "lockPlacedOn";
  @SerializedName(SERIALIZED_NAME_LOCK_PLACED_ON)
  private OffsetDateTime lockPlacedOn;

  public static final String SERIALIZED_NAME_LOCK_PLACED_ON_COB_BUSINESS_DATE = "lockPlacedOnCobBusinessDate";
  @SerializedName(SERIALIZED_NAME_LOCK_PLACED_ON_COB_BUSINESS_DATE)
  private LocalDate lockPlacedOnCobBusinessDate;

  /**
   * Gets or Sets newLockOwner
   */
  @JsonAdapter(NewLockOwnerEnum.Adapter.class)
  public enum NewLockOwnerEnum {
    COB_CHUNK_PROCESSING("LOAN_COB_CHUNK_PROCESSING"),
    
    INLINE_COB_PROCESSING("LOAN_INLINE_COB_PROCESSING");

    private String value;

    NewLockOwnerEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static NewLockOwnerEnum fromValue(String value) {
      for (NewLockOwnerEnum b : NewLockOwnerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<NewLockOwnerEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final NewLockOwnerEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public NewLockOwnerEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return NewLockOwnerEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_NEW_LOCK_OWNER = "newLockOwner";
  @SerializedName(SERIALIZED_NAME_NEW_LOCK_OWNER)
  private NewLockOwnerEnum newLockOwner;

  public static final String SERIALIZED_NAME_STACKTRACE = "stacktrace";
  @SerializedName(SERIALIZED_NAME_STACKTRACE)
  private String stacktrace;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private Long version;

  public LoanAccountLock() {
  }

  public LoanAccountLock error(String error) {
    
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
   */
  @javax.annotation.Nullable

  public String getError() {
    return error;
  }


  public void setError(String error) {
    this.error = error;
  }

  public LoanAccountLock loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public LoanAccountLock lockOwner(LockOwnerEnum lockOwner) {
    
    this.lockOwner = lockOwner;
    return this;
  }

  /**
   * Get lockOwner
   * @return lockOwner
   */
  @javax.annotation.Nullable

  public LockOwnerEnum getLockOwner() {
    return lockOwner;
  }


  public void setLockOwner(LockOwnerEnum lockOwner) {
    this.lockOwner = lockOwner;
  }

  public LoanAccountLock lockPlacedOn(OffsetDateTime lockPlacedOn) {
    
    this.lockPlacedOn = lockPlacedOn;
    return this;
  }

  /**
   * Get lockPlacedOn
   * @return lockPlacedOn
   */
  @javax.annotation.Nullable

  public OffsetDateTime getLockPlacedOn() {
    return lockPlacedOn;
  }


  public void setLockPlacedOn(OffsetDateTime lockPlacedOn) {
    this.lockPlacedOn = lockPlacedOn;
  }

  public LoanAccountLock lockPlacedOnCobBusinessDate(LocalDate lockPlacedOnCobBusinessDate) {
    
    this.lockPlacedOnCobBusinessDate = lockPlacedOnCobBusinessDate;
    return this;
  }

  /**
   * Get lockPlacedOnCobBusinessDate
   * @return lockPlacedOnCobBusinessDate
   */
  @javax.annotation.Nullable

  public LocalDate getLockPlacedOnCobBusinessDate() {
    return lockPlacedOnCobBusinessDate;
  }


  public void setLockPlacedOnCobBusinessDate(LocalDate lockPlacedOnCobBusinessDate) {
    this.lockPlacedOnCobBusinessDate = lockPlacedOnCobBusinessDate;
  }

  public LoanAccountLock newLockOwner(NewLockOwnerEnum newLockOwner) {
    
    this.newLockOwner = newLockOwner;
    return this;
  }

  /**
   * Get newLockOwner
   * @return newLockOwner
   */
  @javax.annotation.Nullable

  public NewLockOwnerEnum getNewLockOwner() {
    return newLockOwner;
  }


  public void setNewLockOwner(NewLockOwnerEnum newLockOwner) {
    this.newLockOwner = newLockOwner;
  }

  public LoanAccountLock stacktrace(String stacktrace) {
    
    this.stacktrace = stacktrace;
    return this;
  }

  /**
   * Get stacktrace
   * @return stacktrace
   */
  @javax.annotation.Nullable

  public String getStacktrace() {
    return stacktrace;
  }


  public void setStacktrace(String stacktrace) {
    this.stacktrace = stacktrace;
  }

  public LoanAccountLock version(Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
   */
  @javax.annotation.Nullable

  public Long getVersion() {
    return version;
  }


  public void setVersion(Long version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanAccountLock loanAccountLock = (LoanAccountLock) o;
    return Objects.equals(this.error, loanAccountLock.error) &&
        Objects.equals(this.loanId, loanAccountLock.loanId) &&
        Objects.equals(this.lockOwner, loanAccountLock.lockOwner) &&
        Objects.equals(this.lockPlacedOn, loanAccountLock.lockPlacedOn) &&
        Objects.equals(this.lockPlacedOnCobBusinessDate, loanAccountLock.lockPlacedOnCobBusinessDate) &&
        Objects.equals(this.newLockOwner, loanAccountLock.newLockOwner) &&
        Objects.equals(this.stacktrace, loanAccountLock.stacktrace) &&
        Objects.equals(this.version, loanAccountLock.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(error, loanId, lockOwner, lockPlacedOn, lockPlacedOnCobBusinessDate, newLockOwner, stacktrace, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanAccountLock {\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    lockOwner: ").append(toIndentedString(lockOwner)).append("\n");
    sb.append("    lockPlacedOn: ").append(toIndentedString(lockPlacedOn)).append("\n");
    sb.append("    lockPlacedOnCobBusinessDate: ").append(toIndentedString(lockPlacedOnCobBusinessDate)).append("\n");
    sb.append("    newLockOwner: ").append(toIndentedString(newLockOwner)).append("\n");
    sb.append("    stacktrace: ").append(toIndentedString(stacktrace)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

