/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.ExtensionData;
import org.apache.fineract.client.models.GeoCodeData;
import org.apache.fineract.client.models.InteropTransactionTypeData;
import org.apache.fineract.client.models.MoneyData;

/**
 * InteropQuoteRequestData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InteropQuoteRequestData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private MoneyData amount;

  /**
   * Gets or Sets amountType
   */
  @JsonAdapter(AmountTypeEnum.Adapter.class)
  public enum AmountTypeEnum {
    SEND("SEND"),
    
    RECEIVE("RECEIVE");

    private String value;

    AmountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AmountTypeEnum fromValue(String value) {
      for (AmountTypeEnum b : AmountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AmountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AmountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AmountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AmountTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_AMOUNT_TYPE = "amountType";
  @SerializedName(SERIALIZED_NAME_AMOUNT_TYPE)
  private AmountTypeEnum amountType;

  public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
  @SerializedName(SERIALIZED_NAME_EXPIRATION)
  private OffsetDateTime expiration;

  public static final String SERIALIZED_NAME_EXPIRATION_LOCAL_DATE = "expirationLocalDate";
  @SerializedName(SERIALIZED_NAME_EXPIRATION_LOCAL_DATE)
  private LocalDate expirationLocalDate;

  public static final String SERIALIZED_NAME_EXTENSION_LIST = "extensionList";
  @SerializedName(SERIALIZED_NAME_EXTENSION_LIST)
  private List<ExtensionData> extensionList;

  public static final String SERIALIZED_NAME_FEES = "fees";
  @SerializedName(SERIALIZED_NAME_FEES)
  private MoneyData fees;

  public static final String SERIALIZED_NAME_GEO_CODE = "geoCode";
  @SerializedName(SERIALIZED_NAME_GEO_CODE)
  private GeoCodeData geoCode;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_QUOTE_CODE = "quoteCode";
  @SerializedName(SERIALIZED_NAME_QUOTE_CODE)
  private String quoteCode;

  public static final String SERIALIZED_NAME_REQUEST_CODE = "requestCode";
  @SerializedName(SERIALIZED_NAME_REQUEST_CODE)
  private String requestCode;

  public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transactionCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_CODE)
  private String transactionCode;

  /**
   * Gets or Sets transactionRole
   */
  @JsonAdapter(TransactionRoleEnum.Adapter.class)
  public enum TransactionRoleEnum {
    PAYER("PAYER"),
    
    PAYEE("PAYEE");

    private String value;

    TransactionRoleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransactionRoleEnum fromValue(String value) {
      for (TransactionRoleEnum b : TransactionRoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransactionRoleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransactionRoleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransactionRoleEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransactionRoleEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSACTION_ROLE = "transactionRole";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ROLE)
  private TransactionRoleEnum transactionRole;

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private InteropTransactionTypeData transactionType;

  public InteropQuoteRequestData() {
  }

  public InteropQuoteRequestData accountId(String accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nonnull

  public String getAccountId() {
    return accountId;
  }


  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public InteropQuoteRequestData amount(MoneyData amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nonnull

  public MoneyData getAmount() {
    return amount;
  }


  public void setAmount(MoneyData amount) {
    this.amount = amount;
  }

  public InteropQuoteRequestData amountType(AmountTypeEnum amountType) {
    
    this.amountType = amountType;
    return this;
  }

  /**
   * Get amountType
   * @return amountType
   */
  @javax.annotation.Nonnull

  public AmountTypeEnum getAmountType() {
    return amountType;
  }


  public void setAmountType(AmountTypeEnum amountType) {
    this.amountType = amountType;
  }

  public InteropQuoteRequestData expiration(OffsetDateTime expiration) {
    
    this.expiration = expiration;
    return this;
  }

  /**
   * Get expiration
   * @return expiration
   */
  @javax.annotation.Nullable

  public OffsetDateTime getExpiration() {
    return expiration;
  }


  public void setExpiration(OffsetDateTime expiration) {
    this.expiration = expiration;
  }

  public InteropQuoteRequestData expirationLocalDate(LocalDate expirationLocalDate) {
    
    this.expirationLocalDate = expirationLocalDate;
    return this;
  }

  /**
   * Get expirationLocalDate
   * @return expirationLocalDate
   */
  @javax.annotation.Nullable

  public LocalDate getExpirationLocalDate() {
    return expirationLocalDate;
  }


  public void setExpirationLocalDate(LocalDate expirationLocalDate) {
    this.expirationLocalDate = expirationLocalDate;
  }

  public InteropQuoteRequestData extensionList(List<ExtensionData> extensionList) {
    
    this.extensionList = extensionList;
    return this;
  }

  public InteropQuoteRequestData addExtensionListItem(ExtensionData extensionListItem) {
    if (this.extensionList == null) {
      this.extensionList = new ArrayList<>();
    }
    this.extensionList.add(extensionListItem);
    return this;
  }

  /**
   * Get extensionList
   * @return extensionList
   */
  @javax.annotation.Nullable

  public List<ExtensionData> getExtensionList() {
    return extensionList;
  }


  public void setExtensionList(List<ExtensionData> extensionList) {
    this.extensionList = extensionList;
  }

  public InteropQuoteRequestData fees(MoneyData fees) {
    
    this.fees = fees;
    return this;
  }

  /**
   * Get fees
   * @return fees
   */
  @javax.annotation.Nullable

  public MoneyData getFees() {
    return fees;
  }


  public void setFees(MoneyData fees) {
    this.fees = fees;
  }

  public InteropQuoteRequestData geoCode(GeoCodeData geoCode) {
    
    this.geoCode = geoCode;
    return this;
  }

  /**
   * Get geoCode
   * @return geoCode
   */
  @javax.annotation.Nullable

  public GeoCodeData getGeoCode() {
    return geoCode;
  }


  public void setGeoCode(GeoCodeData geoCode) {
    this.geoCode = geoCode;
  }

  public InteropQuoteRequestData note(String note) {
    
    this.note = note;
    return this;
  }

  /**
   * Get note
   * @return note
   */
  @javax.annotation.Nullable

  public String getNote() {
    return note;
  }


  public void setNote(String note) {
    this.note = note;
  }

  public InteropQuoteRequestData quoteCode(String quoteCode) {
    
    this.quoteCode = quoteCode;
    return this;
  }

  /**
   * Get quoteCode
   * @return quoteCode
   */
  @javax.annotation.Nonnull

  public String getQuoteCode() {
    return quoteCode;
  }


  public void setQuoteCode(String quoteCode) {
    this.quoteCode = quoteCode;
  }

  public InteropQuoteRequestData requestCode(String requestCode) {
    
    this.requestCode = requestCode;
    return this;
  }

  /**
   * Get requestCode
   * @return requestCode
   */
  @javax.annotation.Nullable

  public String getRequestCode() {
    return requestCode;
  }


  public void setRequestCode(String requestCode) {
    this.requestCode = requestCode;
  }

  public InteropQuoteRequestData transactionCode(String transactionCode) {
    
    this.transactionCode = transactionCode;
    return this;
  }

  /**
   * Get transactionCode
   * @return transactionCode
   */
  @javax.annotation.Nonnull

  public String getTransactionCode() {
    return transactionCode;
  }


  public void setTransactionCode(String transactionCode) {
    this.transactionCode = transactionCode;
  }

  public InteropQuoteRequestData transactionRole(TransactionRoleEnum transactionRole) {
    
    this.transactionRole = transactionRole;
    return this;
  }

  /**
   * Get transactionRole
   * @return transactionRole
   */
  @javax.annotation.Nonnull

  public TransactionRoleEnum getTransactionRole() {
    return transactionRole;
  }


  public void setTransactionRole(TransactionRoleEnum transactionRole) {
    this.transactionRole = transactionRole;
  }

  public InteropQuoteRequestData transactionType(InteropTransactionTypeData transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nullable

  public InteropTransactionTypeData getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(InteropTransactionTypeData transactionType) {
    this.transactionType = transactionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InteropQuoteRequestData interopQuoteRequestData = (InteropQuoteRequestData) o;
    return Objects.equals(this.accountId, interopQuoteRequestData.accountId) &&
        Objects.equals(this.amount, interopQuoteRequestData.amount) &&
        Objects.equals(this.amountType, interopQuoteRequestData.amountType) &&
        Objects.equals(this.expiration, interopQuoteRequestData.expiration) &&
        Objects.equals(this.expirationLocalDate, interopQuoteRequestData.expirationLocalDate) &&
        Objects.equals(this.extensionList, interopQuoteRequestData.extensionList) &&
        Objects.equals(this.fees, interopQuoteRequestData.fees) &&
        Objects.equals(this.geoCode, interopQuoteRequestData.geoCode) &&
        Objects.equals(this.note, interopQuoteRequestData.note) &&
        Objects.equals(this.quoteCode, interopQuoteRequestData.quoteCode) &&
        Objects.equals(this.requestCode, interopQuoteRequestData.requestCode) &&
        Objects.equals(this.transactionCode, interopQuoteRequestData.transactionCode) &&
        Objects.equals(this.transactionRole, interopQuoteRequestData.transactionRole) &&
        Objects.equals(this.transactionType, interopQuoteRequestData.transactionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, amount, amountType, expiration, expirationLocalDate, extensionList, fees, geoCode, note, quoteCode, requestCode, transactionCode, transactionRole, transactionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InteropQuoteRequestData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountType: ").append(toIndentedString(amountType)).append("\n");
    sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
    sb.append("    expirationLocalDate: ").append(toIndentedString(expirationLocalDate)).append("\n");
    sb.append("    extensionList: ").append(toIndentedString(extensionList)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    geoCode: ").append(toIndentedString(geoCode)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    quoteCode: ").append(toIndentedString(quoteCode)).append("\n");
    sb.append("    requestCode: ").append(toIndentedString(requestCode)).append("\n");
    sb.append("    transactionCode: ").append(toIndentedString(transactionCode)).append("\n");
    sb.append("    transactionRole: ").append(toIndentedString(transactionRole)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

