/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fineract.client.models.GetSavingsAccountChargesPaidByData;
import org.apache.fineract.client.models.GetTransactionsCurrency;
import org.apache.fineract.client.models.GetTransactionsPaymentDetailData;
import org.apache.fineract.client.models.GetTranscationEnumData;

/**
 * GetSavingsAccountTransactionsPageItem
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetSavingsAccountTransactionsPageItem {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private Long accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_CHARGES_PAID_BY_DATA = "chargesPaidByData";
  @SerializedName(SERIALIZED_NAME_CHARGES_PAID_BY_DATA)
  private Set<GetSavingsAccountChargesPaidByData> chargesPaidByData;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetTransactionsCurrency currency;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  /**
   * Gets or Sets entryType
   */
  @JsonAdapter(EntryTypeEnum.Adapter.class)
  public enum EntryTypeEnum {
    CREDIT("CREDIT"),
    
    DEBIT("DEBIT");

    private String value;

    EntryTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EntryTypeEnum fromValue(String value) {
      for (EntryTypeEnum b : EntryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EntryTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntryTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EntryTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EntryTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entryType";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private EntryTypeEnum entryType;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INTERESTED_POSTED_AS_ON = "interestedPostedAsOn";
  @SerializedName(SERIALIZED_NAME_INTERESTED_POSTED_AS_ON)
  private Boolean interestedPostedAsOn;

  public static final String SERIALIZED_NAME_IS_MANUAL_TRANSACTION = "isManualTransaction";
  @SerializedName(SERIALIZED_NAME_IS_MANUAL_TRANSACTION)
  private Boolean isManualTransaction;

  public static final String SERIALIZED_NAME_IS_REVERSAL = "isReversal";
  @SerializedName(SERIALIZED_NAME_IS_REVERSAL)
  private Boolean isReversal;

  public static final String SERIALIZED_NAME_LIEN_TRANSACTION = "lienTransaction";
  @SerializedName(SERIALIZED_NAME_LIEN_TRANSACTION)
  private Boolean lienTransaction;

  public static final String SERIALIZED_NAME_ORIGINAL_TRANSACTION_ID = "originalTransactionId";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_TRANSACTION_ID)
  private Long originalTransactionId;

  public static final String SERIALIZED_NAME_PAYMENT_DETAIL_DATA = "paymentDetailData";
  @SerializedName(SERIALIZED_NAME_PAYMENT_DETAIL_DATA)
  private GetTransactionsPaymentDetailData paymentDetailData;

  public static final String SERIALIZED_NAME_RELEASE_TRANSACTION_ID = "releaseTransactionId";
  @SerializedName(SERIALIZED_NAME_RELEASE_TRANSACTION_ID)
  private Long releaseTransactionId;

  public static final String SERIALIZED_NAME_REVERSED = "reversed";
  @SerializedName(SERIALIZED_NAME_REVERSED)
  private Boolean reversed;

  public static final String SERIALIZED_NAME_RUNNING_BALANCE = "runningBalance";
  @SerializedName(SERIALIZED_NAME_RUNNING_BALANCE)
  private BigDecimal runningBalance;

  public static final String SERIALIZED_NAME_SUBMITTED_BY_USERNAME = "submittedByUsername";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_BY_USERNAME)
  private String submittedByUsername;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private GetTranscationEnumData transactionType;

  public GetSavingsAccountTransactionsPageItem() {
  }

  public GetSavingsAccountTransactionsPageItem accountId(Long accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nullable

  public Long getAccountId() {
    return accountId;
  }


  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public GetSavingsAccountTransactionsPageItem accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public GetSavingsAccountTransactionsPageItem amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public GetSavingsAccountTransactionsPageItem chargesPaidByData(Set<GetSavingsAccountChargesPaidByData> chargesPaidByData) {
    
    this.chargesPaidByData = chargesPaidByData;
    return this;
  }

  public GetSavingsAccountTransactionsPageItem addChargesPaidByDataItem(GetSavingsAccountChargesPaidByData chargesPaidByDataItem) {
    if (this.chargesPaidByData == null) {
      this.chargesPaidByData = new LinkedHashSet<>();
    }
    this.chargesPaidByData.add(chargesPaidByDataItem);
    return this;
  }

  /**
   * Get chargesPaidByData
   * @return chargesPaidByData
   */
  @javax.annotation.Nullable

  public Set<GetSavingsAccountChargesPaidByData> getChargesPaidByData() {
    return chargesPaidByData;
  }


  public void setChargesPaidByData(Set<GetSavingsAccountChargesPaidByData> chargesPaidByData) {
    this.chargesPaidByData = chargesPaidByData;
  }

  public GetSavingsAccountTransactionsPageItem currency(GetTransactionsCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetTransactionsCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetTransactionsCurrency currency) {
    this.currency = currency;
  }

  public GetSavingsAccountTransactionsPageItem date(LocalDate date) {
    
    this.date = date;
    return this;
  }

  /**
   * Get date
   * @return date
   */
  @javax.annotation.Nullable

  public LocalDate getDate() {
    return date;
  }


  public void setDate(LocalDate date) {
    this.date = date;
  }

  public GetSavingsAccountTransactionsPageItem entryType(EntryTypeEnum entryType) {
    
    this.entryType = entryType;
    return this;
  }

  /**
   * Get entryType
   * @return entryType
   */
  @javax.annotation.Nullable

  public EntryTypeEnum getEntryType() {
    return entryType;
  }


  public void setEntryType(EntryTypeEnum entryType) {
    this.entryType = entryType;
  }

  public GetSavingsAccountTransactionsPageItem id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GetSavingsAccountTransactionsPageItem interestedPostedAsOn(Boolean interestedPostedAsOn) {
    
    this.interestedPostedAsOn = interestedPostedAsOn;
    return this;
  }

  /**
   * Get interestedPostedAsOn
   * @return interestedPostedAsOn
   */
  @javax.annotation.Nullable

  public Boolean getInterestedPostedAsOn() {
    return interestedPostedAsOn;
  }


  public void setInterestedPostedAsOn(Boolean interestedPostedAsOn) {
    this.interestedPostedAsOn = interestedPostedAsOn;
  }

  public GetSavingsAccountTransactionsPageItem isManualTransaction(Boolean isManualTransaction) {
    
    this.isManualTransaction = isManualTransaction;
    return this;
  }

  /**
   * Get isManualTransaction
   * @return isManualTransaction
   */
  @javax.annotation.Nullable

  public Boolean getIsManualTransaction() {
    return isManualTransaction;
  }


  public void setIsManualTransaction(Boolean isManualTransaction) {
    this.isManualTransaction = isManualTransaction;
  }

  public GetSavingsAccountTransactionsPageItem isReversal(Boolean isReversal) {
    
    this.isReversal = isReversal;
    return this;
  }

  /**
   * Get isReversal
   * @return isReversal
   */
  @javax.annotation.Nullable

  public Boolean getIsReversal() {
    return isReversal;
  }


  public void setIsReversal(Boolean isReversal) {
    this.isReversal = isReversal;
  }

  public GetSavingsAccountTransactionsPageItem lienTransaction(Boolean lienTransaction) {
    
    this.lienTransaction = lienTransaction;
    return this;
  }

  /**
   * Get lienTransaction
   * @return lienTransaction
   */
  @javax.annotation.Nullable

  public Boolean getLienTransaction() {
    return lienTransaction;
  }


  public void setLienTransaction(Boolean lienTransaction) {
    this.lienTransaction = lienTransaction;
  }

  public GetSavingsAccountTransactionsPageItem originalTransactionId(Long originalTransactionId) {
    
    this.originalTransactionId = originalTransactionId;
    return this;
  }

  /**
   * Get originalTransactionId
   * @return originalTransactionId
   */
  @javax.annotation.Nullable

  public Long getOriginalTransactionId() {
    return originalTransactionId;
  }


  public void setOriginalTransactionId(Long originalTransactionId) {
    this.originalTransactionId = originalTransactionId;
  }

  public GetSavingsAccountTransactionsPageItem paymentDetailData(GetTransactionsPaymentDetailData paymentDetailData) {
    
    this.paymentDetailData = paymentDetailData;
    return this;
  }

  /**
   * Get paymentDetailData
   * @return paymentDetailData
   */
  @javax.annotation.Nullable

  public GetTransactionsPaymentDetailData getPaymentDetailData() {
    return paymentDetailData;
  }


  public void setPaymentDetailData(GetTransactionsPaymentDetailData paymentDetailData) {
    this.paymentDetailData = paymentDetailData;
  }

  public GetSavingsAccountTransactionsPageItem releaseTransactionId(Long releaseTransactionId) {
    
    this.releaseTransactionId = releaseTransactionId;
    return this;
  }

  /**
   * Get releaseTransactionId
   * @return releaseTransactionId
   */
  @javax.annotation.Nullable

  public Long getReleaseTransactionId() {
    return releaseTransactionId;
  }


  public void setReleaseTransactionId(Long releaseTransactionId) {
    this.releaseTransactionId = releaseTransactionId;
  }

  public GetSavingsAccountTransactionsPageItem reversed(Boolean reversed) {
    
    this.reversed = reversed;
    return this;
  }

  /**
   * Get reversed
   * @return reversed
   */
  @javax.annotation.Nullable

  public Boolean getReversed() {
    return reversed;
  }


  public void setReversed(Boolean reversed) {
    this.reversed = reversed;
  }

  public GetSavingsAccountTransactionsPageItem runningBalance(BigDecimal runningBalance) {
    
    this.runningBalance = runningBalance;
    return this;
  }

  /**
   * Get runningBalance
   * @return runningBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getRunningBalance() {
    return runningBalance;
  }


  public void setRunningBalance(BigDecimal runningBalance) {
    this.runningBalance = runningBalance;
  }

  public GetSavingsAccountTransactionsPageItem submittedByUsername(String submittedByUsername) {
    
    this.submittedByUsername = submittedByUsername;
    return this;
  }

  /**
   * Get submittedByUsername
   * @return submittedByUsername
   */
  @javax.annotation.Nullable

  public String getSubmittedByUsername() {
    return submittedByUsername;
  }


  public void setSubmittedByUsername(String submittedByUsername) {
    this.submittedByUsername = submittedByUsername;
  }

  public GetSavingsAccountTransactionsPageItem submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public GetSavingsAccountTransactionsPageItem transactionType(GetTranscationEnumData transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nullable

  public GetTranscationEnumData getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(GetTranscationEnumData transactionType) {
    this.transactionType = transactionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSavingsAccountTransactionsPageItem getSavingsAccountTransactionsPageItem = (GetSavingsAccountTransactionsPageItem) o;
    return Objects.equals(this.accountId, getSavingsAccountTransactionsPageItem.accountId) &&
        Objects.equals(this.accountNo, getSavingsAccountTransactionsPageItem.accountNo) &&
        Objects.equals(this.amount, getSavingsAccountTransactionsPageItem.amount) &&
        Objects.equals(this.chargesPaidByData, getSavingsAccountTransactionsPageItem.chargesPaidByData) &&
        Objects.equals(this.currency, getSavingsAccountTransactionsPageItem.currency) &&
        Objects.equals(this.date, getSavingsAccountTransactionsPageItem.date) &&
        Objects.equals(this.entryType, getSavingsAccountTransactionsPageItem.entryType) &&
        Objects.equals(this.id, getSavingsAccountTransactionsPageItem.id) &&
        Objects.equals(this.interestedPostedAsOn, getSavingsAccountTransactionsPageItem.interestedPostedAsOn) &&
        Objects.equals(this.isManualTransaction, getSavingsAccountTransactionsPageItem.isManualTransaction) &&
        Objects.equals(this.isReversal, getSavingsAccountTransactionsPageItem.isReversal) &&
        Objects.equals(this.lienTransaction, getSavingsAccountTransactionsPageItem.lienTransaction) &&
        Objects.equals(this.originalTransactionId, getSavingsAccountTransactionsPageItem.originalTransactionId) &&
        Objects.equals(this.paymentDetailData, getSavingsAccountTransactionsPageItem.paymentDetailData) &&
        Objects.equals(this.releaseTransactionId, getSavingsAccountTransactionsPageItem.releaseTransactionId) &&
        Objects.equals(this.reversed, getSavingsAccountTransactionsPageItem.reversed) &&
        Objects.equals(this.runningBalance, getSavingsAccountTransactionsPageItem.runningBalance) &&
        Objects.equals(this.submittedByUsername, getSavingsAccountTransactionsPageItem.submittedByUsername) &&
        Objects.equals(this.submittedOnDate, getSavingsAccountTransactionsPageItem.submittedOnDate) &&
        Objects.equals(this.transactionType, getSavingsAccountTransactionsPageItem.transactionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountNo, amount, chargesPaidByData, currency, date, entryType, id, interestedPostedAsOn, isManualTransaction, isReversal, lienTransaction, originalTransactionId, paymentDetailData, releaseTransactionId, reversed, runningBalance, submittedByUsername, submittedOnDate, transactionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSavingsAccountTransactionsPageItem {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    chargesPaidByData: ").append(toIndentedString(chargesPaidByData)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    interestedPostedAsOn: ").append(toIndentedString(interestedPostedAsOn)).append("\n");
    sb.append("    isManualTransaction: ").append(toIndentedString(isManualTransaction)).append("\n");
    sb.append("    isReversal: ").append(toIndentedString(isReversal)).append("\n");
    sb.append("    lienTransaction: ").append(toIndentedString(lienTransaction)).append("\n");
    sb.append("    originalTransactionId: ").append(toIndentedString(originalTransactionId)).append("\n");
    sb.append("    paymentDetailData: ").append(toIndentedString(paymentDetailData)).append("\n");
    sb.append("    releaseTransactionId: ").append(toIndentedString(releaseTransactionId)).append("\n");
    sb.append("    reversed: ").append(toIndentedString(reversed)).append("\n");
    sb.append("    runningBalance: ").append(toIndentedString(runningBalance)).append("\n");
    sb.append("    submittedByUsername: ").append(toIndentedString(submittedByUsername)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

