/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import org.apache.fineract.client.models.ExternalTransferDataDetails;
import org.apache.fineract.client.models.ExternalTransferLoanData;
import org.apache.fineract.client.models.ExternalTransferOwnerData;

/**
 * ExternalTransferData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ExternalTransferData {
  public static final String SERIALIZED_NAME_DETAILS = "details";
  @SerializedName(SERIALIZED_NAME_DETAILS)
  private ExternalTransferDataDetails details;

  public static final String SERIALIZED_NAME_EFFECTIVE_FROM = "effectiveFrom";
  @SerializedName(SERIALIZED_NAME_EFFECTIVE_FROM)
  private LocalDate effectiveFrom;

  public static final String SERIALIZED_NAME_EFFECTIVE_TO = "effectiveTo";
  @SerializedName(SERIALIZED_NAME_EFFECTIVE_TO)
  private LocalDate effectiveTo;

  public static final String SERIALIZED_NAME_LOAN = "loan";
  @SerializedName(SERIALIZED_NAME_LOAN)
  private ExternalTransferLoanData loan;

  public static final String SERIALIZED_NAME_OWNER = "owner";
  @SerializedName(SERIALIZED_NAME_OWNER)
  private ExternalTransferOwnerData owner;

  public static final String SERIALIZED_NAME_PURCHASE_PRICE_RATIO = "purchasePriceRatio";
  @SerializedName(SERIALIZED_NAME_PURCHASE_PRICE_RATIO)
  private String purchasePriceRatio;

  public static final String SERIALIZED_NAME_SETTLEMENT_DATE = "settlementDate";
  @SerializedName(SERIALIZED_NAME_SETTLEMENT_DATE)
  private LocalDate settlementDate;

  /**
   * Gets or Sets status
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    DECLINED("DECLINED"),
    
    PENDING("PENDING"),
    
    BUYBACK("BUYBACK"),
    
    CANCELLED("CANCELLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  /**
   * Gets or Sets subStatus
   */
  @JsonAdapter(SubStatusEnum.Adapter.class)
  public enum SubStatusEnum {
    BALANCE_ZERO("BALANCE_ZERO"),
    
    BALANCE_NEGATIVE("BALANCE_NEGATIVE"),
    
    SAMEDAY_TRANSFERS("SAMEDAY_TRANSFERS"),
    
    USER_REQUESTED("USER_REQUESTED"),
    
    UNSOLD("UNSOLD");

    private String value;

    SubStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SubStatusEnum fromValue(String value) {
      for (SubStatusEnum b : SubStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<SubStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SubStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SubStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return SubStatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SUB_STATUS = "subStatus";
  @SerializedName(SERIALIZED_NAME_SUB_STATUS)
  private SubStatusEnum subStatus;

  public static final String SERIALIZED_NAME_TRANSFER_EXTERNAL_ID = "transferExternalId";
  @SerializedName(SERIALIZED_NAME_TRANSFER_EXTERNAL_ID)
  private String transferExternalId;

  public static final String SERIALIZED_NAME_TRANSFER_ID = "transferId";
  @SerializedName(SERIALIZED_NAME_TRANSFER_ID)
  private Long transferId;

  public ExternalTransferData() {
  }

  public ExternalTransferData details(ExternalTransferDataDetails details) {
    
    this.details = details;
    return this;
  }

  /**
   * Get details
   * @return details
   */
  @javax.annotation.Nullable

  public ExternalTransferDataDetails getDetails() {
    return details;
  }


  public void setDetails(ExternalTransferDataDetails details) {
    this.details = details;
  }

  public ExternalTransferData effectiveFrom(LocalDate effectiveFrom) {
    
    this.effectiveFrom = effectiveFrom;
    return this;
  }

  /**
   * Get effectiveFrom
   * @return effectiveFrom
   */
  @javax.annotation.Nullable

  public LocalDate getEffectiveFrom() {
    return effectiveFrom;
  }


  public void setEffectiveFrom(LocalDate effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
  }

  public ExternalTransferData effectiveTo(LocalDate effectiveTo) {
    
    this.effectiveTo = effectiveTo;
    return this;
  }

  /**
   * Get effectiveTo
   * @return effectiveTo
   */
  @javax.annotation.Nullable

  public LocalDate getEffectiveTo() {
    return effectiveTo;
  }


  public void setEffectiveTo(LocalDate effectiveTo) {
    this.effectiveTo = effectiveTo;
  }

  public ExternalTransferData loan(ExternalTransferLoanData loan) {
    
    this.loan = loan;
    return this;
  }

  /**
   * Get loan
   * @return loan
   */
  @javax.annotation.Nullable

  public ExternalTransferLoanData getLoan() {
    return loan;
  }


  public void setLoan(ExternalTransferLoanData loan) {
    this.loan = loan;
  }

  public ExternalTransferData owner(ExternalTransferOwnerData owner) {
    
    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   * @return owner
   */
  @javax.annotation.Nullable

  public ExternalTransferOwnerData getOwner() {
    return owner;
  }


  public void setOwner(ExternalTransferOwnerData owner) {
    this.owner = owner;
  }

  public ExternalTransferData purchasePriceRatio(String purchasePriceRatio) {
    
    this.purchasePriceRatio = purchasePriceRatio;
    return this;
  }

  /**
   * Get purchasePriceRatio
   * @return purchasePriceRatio
   */
  @javax.annotation.Nullable

  public String getPurchasePriceRatio() {
    return purchasePriceRatio;
  }


  public void setPurchasePriceRatio(String purchasePriceRatio) {
    this.purchasePriceRatio = purchasePriceRatio;
  }

  public ExternalTransferData settlementDate(LocalDate settlementDate) {
    
    this.settlementDate = settlementDate;
    return this;
  }

  /**
   * Get settlementDate
   * @return settlementDate
   */
  @javax.annotation.Nullable

  public LocalDate getSettlementDate() {
    return settlementDate;
  }


  public void setSettlementDate(LocalDate settlementDate) {
    this.settlementDate = settlementDate;
  }

  public ExternalTransferData status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public ExternalTransferData subStatus(SubStatusEnum subStatus) {
    
    this.subStatus = subStatus;
    return this;
  }

  /**
   * Get subStatus
   * @return subStatus
   */
  @javax.annotation.Nullable

  public SubStatusEnum getSubStatus() {
    return subStatus;
  }


  public void setSubStatus(SubStatusEnum subStatus) {
    this.subStatus = subStatus;
  }

  public ExternalTransferData transferExternalId(String transferExternalId) {
    
    this.transferExternalId = transferExternalId;
    return this;
  }

  /**
   * Get transferExternalId
   * @return transferExternalId
   */
  @javax.annotation.Nullable

  public String getTransferExternalId() {
    return transferExternalId;
  }


  public void setTransferExternalId(String transferExternalId) {
    this.transferExternalId = transferExternalId;
  }

  public ExternalTransferData transferId(Long transferId) {
    
    this.transferId = transferId;
    return this;
  }

  /**
   * Get transferId
   * @return transferId
   */
  @javax.annotation.Nullable

  public Long getTransferId() {
    return transferId;
  }


  public void setTransferId(Long transferId) {
    this.transferId = transferId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalTransferData externalTransferData = (ExternalTransferData) o;
    return Objects.equals(this.details, externalTransferData.details) &&
        Objects.equals(this.effectiveFrom, externalTransferData.effectiveFrom) &&
        Objects.equals(this.effectiveTo, externalTransferData.effectiveTo) &&
        Objects.equals(this.loan, externalTransferData.loan) &&
        Objects.equals(this.owner, externalTransferData.owner) &&
        Objects.equals(this.purchasePriceRatio, externalTransferData.purchasePriceRatio) &&
        Objects.equals(this.settlementDate, externalTransferData.settlementDate) &&
        Objects.equals(this.status, externalTransferData.status) &&
        Objects.equals(this.subStatus, externalTransferData.subStatus) &&
        Objects.equals(this.transferExternalId, externalTransferData.transferExternalId) &&
        Objects.equals(this.transferId, externalTransferData.transferId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(details, effectiveFrom, effectiveTo, loan, owner, purchasePriceRatio, settlementDate, status, subStatus, transferExternalId, transferId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalTransferData {\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    effectiveFrom: ").append(toIndentedString(effectiveFrom)).append("\n");
    sb.append("    effectiveTo: ").append(toIndentedString(effectiveTo)).append("\n");
    sb.append("    loan: ").append(toIndentedString(loan)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    purchasePriceRatio: ").append(toIndentedString(purchasePriceRatio)).append("\n");
    sb.append("    settlementDate: ").append(toIndentedString(settlementDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subStatus: ").append(toIndentedString(subStatus)).append("\n");
    sb.append("    transferExternalId: ").append(toIndentedString(transferExternalId)).append("\n");
    sb.append("    transferId: ").append(toIndentedString(transferId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

