/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.AccountingTagRuleData;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.GLAccountData;
import org.apache.fineract.client.models.GLAccountDataForLookup;
import org.apache.fineract.client.models.OfficeData;

/**
 * AccountingRuleData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class AccountingRuleData {
  public static final String SERIALIZED_NAME_ALLOW_MULTIPLE_CREDIT_ENTRIES = "allowMultipleCreditEntries";
  @SerializedName(SERIALIZED_NAME_ALLOW_MULTIPLE_CREDIT_ENTRIES)
  private Boolean allowMultipleCreditEntries;

  public static final String SERIALIZED_NAME_ALLOW_MULTIPLE_DEBIT_ENTRIES = "allowMultipleDebitEntries";
  @SerializedName(SERIALIZED_NAME_ALLOW_MULTIPLE_DEBIT_ENTRIES)
  private Boolean allowMultipleDebitEntries;

  public static final String SERIALIZED_NAME_ALLOWED_ACCOUNTS = "allowedAccounts";
  @SerializedName(SERIALIZED_NAME_ALLOWED_ACCOUNTS)
  private List<GLAccountData> allowedAccounts;

  public static final String SERIALIZED_NAME_ALLOWED_CREDIT_TAG_OPTIONS = "allowedCreditTagOptions";
  @SerializedName(SERIALIZED_NAME_ALLOWED_CREDIT_TAG_OPTIONS)
  private List<CodeValueData> allowedCreditTagOptions;

  public static final String SERIALIZED_NAME_ALLOWED_DEBIT_TAG_OPTIONS = "allowedDebitTagOptions";
  @SerializedName(SERIALIZED_NAME_ALLOWED_DEBIT_TAG_OPTIONS)
  private List<CodeValueData> allowedDebitTagOptions;

  public static final String SERIALIZED_NAME_ALLOWED_OFFICES = "allowedOffices";
  @SerializedName(SERIALIZED_NAME_ALLOWED_OFFICES)
  private List<OfficeData> allowedOffices;

  public static final String SERIALIZED_NAME_CREDIT_ACCOUNTS = "creditAccounts";
  @SerializedName(SERIALIZED_NAME_CREDIT_ACCOUNTS)
  private List<GLAccountDataForLookup> creditAccounts;

  public static final String SERIALIZED_NAME_CREDIT_TAGS = "creditTags";
  @SerializedName(SERIALIZED_NAME_CREDIT_TAGS)
  private List<AccountingTagRuleData> creditTags;

  public static final String SERIALIZED_NAME_DEBIT_ACCOUNTS = "debitAccounts";
  @SerializedName(SERIALIZED_NAME_DEBIT_ACCOUNTS)
  private List<GLAccountDataForLookup> debitAccounts;

  public static final String SERIALIZED_NAME_DEBIT_TAGS = "debitTags";
  @SerializedName(SERIALIZED_NAME_DEBIT_TAGS)
  private List<AccountingTagRuleData> debitTags;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_SYSTEM_DEFINED = "systemDefined";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DEFINED)
  private Boolean systemDefined;

  public AccountingRuleData() {
  }

  public AccountingRuleData allowMultipleCreditEntries(Boolean allowMultipleCreditEntries) {
    
    this.allowMultipleCreditEntries = allowMultipleCreditEntries;
    return this;
  }

  /**
   * Get allowMultipleCreditEntries
   * @return allowMultipleCreditEntries
   */
  @javax.annotation.Nullable

  public Boolean getAllowMultipleCreditEntries() {
    return allowMultipleCreditEntries;
  }


  public void setAllowMultipleCreditEntries(Boolean allowMultipleCreditEntries) {
    this.allowMultipleCreditEntries = allowMultipleCreditEntries;
  }

  public AccountingRuleData allowMultipleDebitEntries(Boolean allowMultipleDebitEntries) {
    
    this.allowMultipleDebitEntries = allowMultipleDebitEntries;
    return this;
  }

  /**
   * Get allowMultipleDebitEntries
   * @return allowMultipleDebitEntries
   */
  @javax.annotation.Nullable

  public Boolean getAllowMultipleDebitEntries() {
    return allowMultipleDebitEntries;
  }


  public void setAllowMultipleDebitEntries(Boolean allowMultipleDebitEntries) {
    this.allowMultipleDebitEntries = allowMultipleDebitEntries;
  }

  public AccountingRuleData allowedAccounts(List<GLAccountData> allowedAccounts) {
    
    this.allowedAccounts = allowedAccounts;
    return this;
  }

  public AccountingRuleData addAllowedAccountsItem(GLAccountData allowedAccountsItem) {
    if (this.allowedAccounts == null) {
      this.allowedAccounts = new ArrayList<>();
    }
    this.allowedAccounts.add(allowedAccountsItem);
    return this;
  }

  /**
   * Get allowedAccounts
   * @return allowedAccounts
   */
  @javax.annotation.Nullable

  public List<GLAccountData> getAllowedAccounts() {
    return allowedAccounts;
  }


  public void setAllowedAccounts(List<GLAccountData> allowedAccounts) {
    this.allowedAccounts = allowedAccounts;
  }

  public AccountingRuleData allowedCreditTagOptions(List<CodeValueData> allowedCreditTagOptions) {
    
    this.allowedCreditTagOptions = allowedCreditTagOptions;
    return this;
  }

  public AccountingRuleData addAllowedCreditTagOptionsItem(CodeValueData allowedCreditTagOptionsItem) {
    if (this.allowedCreditTagOptions == null) {
      this.allowedCreditTagOptions = new ArrayList<>();
    }
    this.allowedCreditTagOptions.add(allowedCreditTagOptionsItem);
    return this;
  }

  /**
   * Get allowedCreditTagOptions
   * @return allowedCreditTagOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getAllowedCreditTagOptions() {
    return allowedCreditTagOptions;
  }


  public void setAllowedCreditTagOptions(List<CodeValueData> allowedCreditTagOptions) {
    this.allowedCreditTagOptions = allowedCreditTagOptions;
  }

  public AccountingRuleData allowedDebitTagOptions(List<CodeValueData> allowedDebitTagOptions) {
    
    this.allowedDebitTagOptions = allowedDebitTagOptions;
    return this;
  }

  public AccountingRuleData addAllowedDebitTagOptionsItem(CodeValueData allowedDebitTagOptionsItem) {
    if (this.allowedDebitTagOptions == null) {
      this.allowedDebitTagOptions = new ArrayList<>();
    }
    this.allowedDebitTagOptions.add(allowedDebitTagOptionsItem);
    return this;
  }

  /**
   * Get allowedDebitTagOptions
   * @return allowedDebitTagOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getAllowedDebitTagOptions() {
    return allowedDebitTagOptions;
  }


  public void setAllowedDebitTagOptions(List<CodeValueData> allowedDebitTagOptions) {
    this.allowedDebitTagOptions = allowedDebitTagOptions;
  }

  public AccountingRuleData allowedOffices(List<OfficeData> allowedOffices) {
    
    this.allowedOffices = allowedOffices;
    return this;
  }

  public AccountingRuleData addAllowedOfficesItem(OfficeData allowedOfficesItem) {
    if (this.allowedOffices == null) {
      this.allowedOffices = new ArrayList<>();
    }
    this.allowedOffices.add(allowedOfficesItem);
    return this;
  }

  /**
   * Get allowedOffices
   * @return allowedOffices
   */
  @javax.annotation.Nullable

  public List<OfficeData> getAllowedOffices() {
    return allowedOffices;
  }


  public void setAllowedOffices(List<OfficeData> allowedOffices) {
    this.allowedOffices = allowedOffices;
  }

  public AccountingRuleData creditAccounts(List<GLAccountDataForLookup> creditAccounts) {
    
    this.creditAccounts = creditAccounts;
    return this;
  }

  public AccountingRuleData addCreditAccountsItem(GLAccountDataForLookup creditAccountsItem) {
    if (this.creditAccounts == null) {
      this.creditAccounts = new ArrayList<>();
    }
    this.creditAccounts.add(creditAccountsItem);
    return this;
  }

  /**
   * Get creditAccounts
   * @return creditAccounts
   */
  @javax.annotation.Nullable

  public List<GLAccountDataForLookup> getCreditAccounts() {
    return creditAccounts;
  }


  public void setCreditAccounts(List<GLAccountDataForLookup> creditAccounts) {
    this.creditAccounts = creditAccounts;
  }

  public AccountingRuleData creditTags(List<AccountingTagRuleData> creditTags) {
    
    this.creditTags = creditTags;
    return this;
  }

  public AccountingRuleData addCreditTagsItem(AccountingTagRuleData creditTagsItem) {
    if (this.creditTags == null) {
      this.creditTags = new ArrayList<>();
    }
    this.creditTags.add(creditTagsItem);
    return this;
  }

  /**
   * Get creditTags
   * @return creditTags
   */
  @javax.annotation.Nullable

  public List<AccountingTagRuleData> getCreditTags() {
    return creditTags;
  }


  public void setCreditTags(List<AccountingTagRuleData> creditTags) {
    this.creditTags = creditTags;
  }

  public AccountingRuleData debitAccounts(List<GLAccountDataForLookup> debitAccounts) {
    
    this.debitAccounts = debitAccounts;
    return this;
  }

  public AccountingRuleData addDebitAccountsItem(GLAccountDataForLookup debitAccountsItem) {
    if (this.debitAccounts == null) {
      this.debitAccounts = new ArrayList<>();
    }
    this.debitAccounts.add(debitAccountsItem);
    return this;
  }

  /**
   * Get debitAccounts
   * @return debitAccounts
   */
  @javax.annotation.Nullable

  public List<GLAccountDataForLookup> getDebitAccounts() {
    return debitAccounts;
  }


  public void setDebitAccounts(List<GLAccountDataForLookup> debitAccounts) {
    this.debitAccounts = debitAccounts;
  }

  public AccountingRuleData debitTags(List<AccountingTagRuleData> debitTags) {
    
    this.debitTags = debitTags;
    return this;
  }

  public AccountingRuleData addDebitTagsItem(AccountingTagRuleData debitTagsItem) {
    if (this.debitTags == null) {
      this.debitTags = new ArrayList<>();
    }
    this.debitTags.add(debitTagsItem);
    return this;
  }

  /**
   * Get debitTags
   * @return debitTags
   */
  @javax.annotation.Nullable

  public List<AccountingTagRuleData> getDebitTags() {
    return debitTags;
  }


  public void setDebitTags(List<AccountingTagRuleData> debitTags) {
    this.debitTags = debitTags;
  }

  public AccountingRuleData description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public AccountingRuleData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public AccountingRuleData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public AccountingRuleData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public AccountingRuleData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public AccountingRuleData systemDefined(Boolean systemDefined) {
    
    this.systemDefined = systemDefined;
    return this;
  }

  /**
   * Get systemDefined
   * @return systemDefined
   */
  @javax.annotation.Nullable

  public Boolean getSystemDefined() {
    return systemDefined;
  }


  public void setSystemDefined(Boolean systemDefined) {
    this.systemDefined = systemDefined;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountingRuleData accountingRuleData = (AccountingRuleData) o;
    return Objects.equals(this.allowMultipleCreditEntries, accountingRuleData.allowMultipleCreditEntries) &&
        Objects.equals(this.allowMultipleDebitEntries, accountingRuleData.allowMultipleDebitEntries) &&
        Objects.equals(this.allowedAccounts, accountingRuleData.allowedAccounts) &&
        Objects.equals(this.allowedCreditTagOptions, accountingRuleData.allowedCreditTagOptions) &&
        Objects.equals(this.allowedDebitTagOptions, accountingRuleData.allowedDebitTagOptions) &&
        Objects.equals(this.allowedOffices, accountingRuleData.allowedOffices) &&
        Objects.equals(this.creditAccounts, accountingRuleData.creditAccounts) &&
        Objects.equals(this.creditTags, accountingRuleData.creditTags) &&
        Objects.equals(this.debitAccounts, accountingRuleData.debitAccounts) &&
        Objects.equals(this.debitTags, accountingRuleData.debitTags) &&
        Objects.equals(this.description, accountingRuleData.description) &&
        Objects.equals(this.id, accountingRuleData.id) &&
        Objects.equals(this.name, accountingRuleData.name) &&
        Objects.equals(this.officeId, accountingRuleData.officeId) &&
        Objects.equals(this.officeName, accountingRuleData.officeName) &&
        Objects.equals(this.systemDefined, accountingRuleData.systemDefined);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowMultipleCreditEntries, allowMultipleDebitEntries, allowedAccounts, allowedCreditTagOptions, allowedDebitTagOptions, allowedOffices, creditAccounts, creditTags, debitAccounts, debitTags, description, id, name, officeId, officeName, systemDefined);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountingRuleData {\n");
    sb.append("    allowMultipleCreditEntries: ").append(toIndentedString(allowMultipleCreditEntries)).append("\n");
    sb.append("    allowMultipleDebitEntries: ").append(toIndentedString(allowMultipleDebitEntries)).append("\n");
    sb.append("    allowedAccounts: ").append(toIndentedString(allowedAccounts)).append("\n");
    sb.append("    allowedCreditTagOptions: ").append(toIndentedString(allowedCreditTagOptions)).append("\n");
    sb.append("    allowedDebitTagOptions: ").append(toIndentedString(allowedDebitTagOptions)).append("\n");
    sb.append("    allowedOffices: ").append(toIndentedString(allowedOffices)).append("\n");
    sb.append("    creditAccounts: ").append(toIndentedString(creditAccounts)).append("\n");
    sb.append("    creditTags: ").append(toIndentedString(creditTags)).append("\n");
    sb.append("    debitAccounts: ").append(toIndentedString(debitAccounts)).append("\n");
    sb.append("    debitTags: ").append(toIndentedString(debitTags)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    systemDefined: ").append(toIndentedString(systemDefined)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

